/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.bayes.model;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.FiniteProbabilityModel;
import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.BayesInference;
import aima.core.probability.bayes.BayesianNetwork;
import aima.core.probability.bayes.exact.EnumerationAsk;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.proposition.ConjunctiveProposition;
import aima.core.probability.proposition.Proposition;
import aima.core.probability.util.ProbUtil;
import aima.core.probability.util.ProbabilityTable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class FiniteBayesModel
implements FiniteProbabilityModel {
    private BayesianNetwork bayesNet = null;
    private Set<RandomVariable> representation = new LinkedHashSet<RandomVariable>();
    private BayesInference bayesInference = null;

    public FiniteBayesModel(BayesianNetwork bn) {
        this(bn, new EnumerationAsk());
    }

    public FiniteBayesModel(BayesianNetwork bn, BayesInference bi) {
        if (null == bn) {
            throw new IllegalArgumentException("Bayesian Network describing the model must be specified.");
        }
        this.bayesNet = bn;
        this.representation.addAll(bn.getVariablesInTopologicalOrder());
        this.setBayesInference(bi);
    }

    public BayesInference getBayesInference() {
        return this.bayesInference;
    }

    public void setBayesInference(BayesInference bi) {
        this.bayesInference = bi;
    }

    @Override
    public boolean isValid() {
        return Math.abs(1.0 - this.prior(this.representation.toArray(new Proposition[this.representation.size()]))) <= 1.0E-8;
    }

    @Override
    public double prior(Proposition ... phi) {
        final Proposition conjunct = ProbUtil.constructConjunction(phi);
        RandomVariable[] X = conjunct.getScope().toArray(new RandomVariable[conjunct.getScope().size()]);
        CategoricalDistribution d = this.bayesInference.ask(X, new AssignmentProposition[0], this.bayesNet);
        final double[] probSum = new double[1];
        CategoricalDistribution.Iterator di = new CategoricalDistribution.Iterator(){

            @Override
            public void iterate(Map<RandomVariable, Object> possibleWorld, double probability) {
                if (conjunct.holds(possibleWorld)) {
                    probSum[0] = probSum[0] + probability;
                }
            }
        };
        d.iterateOver(di);
        return probSum[0];
    }

    @Override
    public double posterior(Proposition phi, Proposition ... evidence) {
        Proposition conjEvidence = ProbUtil.constructConjunction(evidence);
        ConjunctiveProposition aAndB = new ConjunctiveProposition(phi, conjEvidence);
        double probabilityOfEvidence = this.prior(conjEvidence);
        if (0.0 != probabilityOfEvidence) {
            return this.prior(aAndB) / probabilityOfEvidence;
        }
        return 0.0;
    }

    @Override
    public Set<RandomVariable> getRepresentation() {
        return this.representation;
    }

    @Override
    public CategoricalDistribution priorDistribution(Proposition ... phi) {
        return this.jointDistribution(phi);
    }

    @Override
    public CategoricalDistribution posteriorDistribution(Proposition phi, Proposition ... evidence) {
        Proposition conjEvidence = ProbUtil.constructConjunction(evidence);
        CategoricalDistribution dAandB = this.jointDistribution(phi, conjEvidence);
        CategoricalDistribution dEvidence = this.jointDistribution(conjEvidence);
        CategoricalDistribution rVal = dAandB.divideBy(dEvidence);
        boolean unboundEvidence = false;
        for (Proposition e : evidence) {
            if (e.getUnboundScope().size() <= 0) continue;
            unboundEvidence = true;
            break;
        }
        if (!unboundEvidence) {
            rVal.normalize();
        }
        return rVal;
    }

    @Override
    public CategoricalDistribution jointDistribution(Proposition ... propositions) {
        ProbabilityTable d = null;
        final Proposition conjProp = ProbUtil.constructConjunction(propositions);
        final LinkedHashSet<RandomVariable> vars = new LinkedHashSet<RandomVariable>(conjProp.getUnboundScope());
        if (vars.size() > 0) {
            RandomVariable[] distVars = new RandomVariable[vars.size()];
            int i = 0;
            Iterator iterator = vars.iterator();
            while (iterator.hasNext()) {
                RandomVariable rv;
                distVars[i] = rv = (RandomVariable)iterator.next();
                ++i;
            }
            final ProbabilityTable ud = new ProbabilityTable(distVars);
            final Object[] values = new Object[vars.size()];
            CategoricalDistribution.Iterator di = new CategoricalDistribution.Iterator(){

                @Override
                public void iterate(Map<RandomVariable, Object> possibleWorld, double probability) {
                    if (conjProp.holds(possibleWorld)) {
                        int i = 0;
                        for (RandomVariable rv : vars) {
                            values[i] = possibleWorld.get(rv);
                            ++i;
                        }
                        int dIdx = ud.getIndex(values);
                        ud.setValue(dIdx, ud.getValues()[dIdx] + probability);
                    }
                }
            };
            RandomVariable[] X = conjProp.getScope().toArray(new RandomVariable[conjProp.getScope().size()]);
            this.bayesInference.ask(X, new AssignmentProposition[0], this.bayesNet).iterateOver(di);
            d = ud;
        } else {
            d = new ProbabilityTable(new RandomVariable[0]);
            d.setValue(0, this.prior(propositions));
        }
        return d;
    }
}

