/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.bayes.impl;

import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.BayesianNetwork;
import aima.core.probability.bayes.DynamicBayesianNetwork;
import aima.core.probability.bayes.Node;
import aima.core.probability.bayes.impl.BayesNet;
import aima.core.util.SetOps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DynamicBayesNet
extends BayesNet
implements DynamicBayesianNetwork {
    private Set<RandomVariable> X_0 = new LinkedHashSet<RandomVariable>();
    private Set<RandomVariable> X_1 = new LinkedHashSet<RandomVariable>();
    private Set<RandomVariable> E_1 = new LinkedHashSet<RandomVariable>();
    private Map<RandomVariable, RandomVariable> X_0_to_X_1 = new LinkedHashMap<RandomVariable, RandomVariable>();
    private Map<RandomVariable, RandomVariable> X_1_to_X_0 = new LinkedHashMap<RandomVariable, RandomVariable>();
    private BayesianNetwork priorNetwork = null;
    private List<RandomVariable> X_1_VariablesInTopologicalOrder = new ArrayList<RandomVariable>();

    public DynamicBayesNet(BayesianNetwork priorNetwork, Map<RandomVariable, RandomVariable> X_0_to_X_1, Set<RandomVariable> E_1, Node ... rootNodes) {
        super(rootNodes);
        for (Map.Entry<RandomVariable, RandomVariable> x0_x1 : X_0_to_X_1.entrySet()) {
            RandomVariable x0 = x0_x1.getKey();
            RandomVariable x1 = x0_x1.getValue();
            this.X_0.add(x0);
            this.X_1.add(x1);
            this.X_0_to_X_1.put(x0, x1);
            this.X_1_to_X_0.put(x1, x0);
        }
        this.E_1.addAll(E_1);
        LinkedHashSet<RandomVariable> combined = new LinkedHashSet<RandomVariable>();
        combined.addAll(this.X_0);
        combined.addAll(this.X_1);
        combined.addAll(E_1);
        if (SetOps.difference(this.varToNodeMap.keySet(), combined).size() != 0) {
            throw new IllegalArgumentException("X_0, X_1, and E_1 do not map correctly to the Nodes describing this Dynamic Bayesian Network.");
        }
        this.priorNetwork = priorNetwork;
        this.X_1_VariablesInTopologicalOrder.addAll(this.getVariablesInTopologicalOrder());
        this.X_1_VariablesInTopologicalOrder.removeAll(this.X_0);
        this.X_1_VariablesInTopologicalOrder.removeAll(E_1);
    }

    @Override
    public BayesianNetwork getPriorNetwork() {
        return this.priorNetwork;
    }

    @Override
    public Set<RandomVariable> getX_0() {
        return this.X_0;
    }

    @Override
    public Set<RandomVariable> getX_1() {
        return this.X_1;
    }

    @Override
    public List<RandomVariable> getX_1_VariablesInTopologicalOrder() {
        return this.X_1_VariablesInTopologicalOrder;
    }

    @Override
    public Map<RandomVariable, RandomVariable> getX_0_to_X_1() {
        return this.X_0_to_X_1;
    }

    @Override
    public Map<RandomVariable, RandomVariable> getX_1_to_X_0() {
        return this.X_1_to_X_0;
    }

    @Override
    public Set<RandomVariable> getE_1() {
        return this.E_1;
    }
}

