/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.bayes.impl;

import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.BayesianNetwork;
import aima.core.probability.bayes.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BayesNet
implements BayesianNetwork {
    protected Set<Node> rootNodes = new LinkedHashSet<Node>();
    protected List<RandomVariable> variables = new ArrayList<RandomVariable>();
    protected Map<RandomVariable, Node> varToNodeMap = new HashMap<RandomVariable, Node>();

    public BayesNet(Node ... rootNodes) {
        if (null == rootNodes) {
            throw new IllegalArgumentException("Root Nodes need to be specified.");
        }
        for (Node n : rootNodes) {
            this.rootNodes.add(n);
        }
        if (this.rootNodes.size() != rootNodes.length) {
            throw new IllegalArgumentException("Duplicate Root Nodes Passed in.");
        }
        this.checkIsDAGAndCollectVariablesInTopologicalOrder();
        this.variables = Collections.unmodifiableList(this.variables);
    }

    @Override
    public List<RandomVariable> getVariablesInTopologicalOrder() {
        return this.variables;
    }

    @Override
    public Node getNode(RandomVariable rv) {
        return this.varToNodeMap.get(rv);
    }

    private void checkIsDAGAndCollectVariablesInTopologicalOrder() {
        HashSet<Node> seenAlready = new HashSet<Node>();
        HashMap<Node, List<Node>> incomingEdges = new HashMap<Node, List<Node>>();
        LinkedHashSet<Node> s = new LinkedHashSet<Node>();
        for (Node node : this.rootNodes) {
            this.walkNode(node, seenAlready, incomingEdges, s);
        }
        while (!s.isEmpty()) {
            Node n = (Node)s.iterator().next();
            s.remove(n);
            this.variables.add(n.getRandomVariable());
            this.varToNodeMap.put(n.getRandomVariable(), n);
            for (Node m : n.getChildren()) {
                List edges = (List)incomingEdges.get(m);
                edges.remove(n);
                if (!edges.isEmpty()) continue;
                s.add(m);
            }
        }
        for (List list : incomingEdges.values()) {
            if (list.isEmpty()) continue;
            throw new IllegalArgumentException("Network contains at least one cycle in it, must be a DAG.");
        }
    }

    private void walkNode(Node n, Set<Node> seenAlready, Map<Node, List<Node>> incomingEdges, Set<Node> rootNodes) {
        if (!seenAlready.contains(n)) {
            seenAlready.add(n);
            if (n.isRoot()) {
                rootNodes.add(n);
            }
            incomingEdges.put(n, new ArrayList<Node>(n.getParents()));
            for (Node c : n.getChildren()) {
                this.walkNode(c, seenAlready, incomingEdges, rootNodes);
            }
        }
    }
}

