/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.bayes.impl;

import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.ConditionalProbabilityDistribution;
import aima.core.probability.bayes.Node;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractNode
implements Node {
    private RandomVariable variable = null;
    private Set<Node> parents = null;
    private Set<Node> children = null;

    public AbstractNode(RandomVariable var) {
        this(var, null);
    }

    public AbstractNode(RandomVariable var, Node ... parents) {
        if (null == var) {
            throw new IllegalArgumentException("Random Variable for Node must be specified.");
        }
        this.variable = var;
        this.parents = new LinkedHashSet<Node>();
        if (null != parents) {
            for (Node p : parents) {
                ((AbstractNode)p).addChild(this);
                this.parents.add(p);
            }
        }
        this.parents = Collections.unmodifiableSet(this.parents);
        this.children = Collections.unmodifiableSet(new LinkedHashSet());
    }

    @Override
    public RandomVariable getRandomVariable() {
        return this.variable;
    }

    @Override
    public boolean isRoot() {
        return 0 == this.getParents().size();
    }

    @Override
    public Set<Node> getParents() {
        return this.parents;
    }

    @Override
    public Set<Node> getChildren() {
        return this.children;
    }

    @Override
    public Set<Node> getMarkovBlanket() {
        LinkedHashSet<Node> mb = new LinkedHashSet<Node>();
        mb.addAll(this.getParents());
        mb.addAll(this.getChildren());
        for (Node cn : this.getChildren()) {
            mb.addAll(cn.getParents());
        }
        return mb;
    }

    @Override
    public abstract ConditionalProbabilityDistribution getCPD();

    public String toString() {
        return this.getRandomVariable().getName();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Node) {
            Node n = (Node)o;
            return this.getRandomVariable().equals(n.getRandomVariable());
        }
        return false;
    }

    public int hashCode() {
        return this.variable.hashCode();
    }

    protected void addChild(Node childNode) {
        this.children = new LinkedHashSet<Node>(this.children);
        this.children.add(childNode);
        this.children = Collections.unmodifiableSet(this.children);
    }
}

