/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.bayes.exact;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.BayesInference;
import aima.core.probability.bayes.BayesianNetwork;
import aima.core.probability.bayes.FiniteNode;
import aima.core.probability.bayes.Node;
import aima.core.probability.domain.FiniteDomain;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.util.ProbabilityTable;
import aima.core.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnumerationAsk
implements BayesInference {
    public CategoricalDistribution enumerationAsk(final RandomVariable[] X, AssignmentProposition[] observedEvidence, final BayesianNetwork bn) {
        final ProbabilityTable Q = new ProbabilityTable(X);
        final ObservedEvidence e = new ObservedEvidence(X, observedEvidence, bn);
        ProbabilityTable.Iterator di = new ProbabilityTable.Iterator(){
            int cnt = 0;

            @Override
            public void iterate(Map<RandomVariable, Object> possibleWorld, double probability) {
                for (int i = 0; i < X.length; ++i) {
                    e.setExtendedValue(X[i], possibleWorld.get(X[i]));
                }
                Q.setValue(this.cnt, EnumerationAsk.this.enumerateAll(bn.getVariablesInTopologicalOrder(), e));
                ++this.cnt;
            }
        };
        Q.iterateOverTable(di);
        return Q.normalize();
    }

    @Override
    public CategoricalDistribution ask(RandomVariable[] X, AssignmentProposition[] observedEvidence, BayesianNetwork bn) {
        return this.enumerationAsk(X, observedEvidence, bn);
    }

    protected double enumerateAll(List<RandomVariable> vars, ObservedEvidence e) {
        if (0 == vars.size()) {
            return 1.0;
        }
        RandomVariable Y = Util.first(vars);
        if (e.containsValue(Y)) {
            return e.posteriorForParents(Y) * this.enumerateAll(Util.rest(vars), e);
        }
        double sum = 0.0;
        for (Object object : ((FiniteDomain)Y.getDomain()).getPossibleValues()) {
            e.setExtendedValue(Y, object);
            sum += e.posteriorForParents(Y) * this.enumerateAll(Util.rest(vars), e);
        }
        return sum;
    }

    protected class ObservedEvidence {
        private BayesianNetwork bn = null;
        private Object[] extendedValues = null;
        private int hiddenStart = 0;
        private int extendedIdx = 0;
        private RandomVariable[] var = null;
        private Map<RandomVariable, Integer> varIdxs = new HashMap<RandomVariable, Integer>();

        public ObservedEvidence(RandomVariable[] queryVariables, AssignmentProposition[] e, BayesianNetwork bn) {
            int i;
            this.bn = bn;
            int maxSize = bn.getVariablesInTopologicalOrder().size();
            this.extendedValues = new Object[maxSize];
            this.var = new RandomVariable[maxSize];
            int idx = 0;
            for (i = 0; i < queryVariables.length; ++i) {
                this.var[idx] = queryVariables[i];
                this.varIdxs.put(this.var[idx], idx);
                ++idx;
            }
            for (i = 0; i < e.length; ++i) {
                this.var[idx] = e[i].getTermVariable();
                this.varIdxs.put(this.var[idx], idx);
                this.extendedValues[idx] = e[i].getValue();
                ++idx;
            }
            this.extendedIdx = idx - 1;
            this.hiddenStart = idx;
            for (RandomVariable rv : bn.getVariablesInTopologicalOrder()) {
                if (this.varIdxs.containsKey(rv)) continue;
                this.var[idx] = rv;
                this.varIdxs.put(this.var[idx], idx);
                ++idx;
            }
        }

        public void setExtendedValue(RandomVariable rv, Object value) {
            int idx = this.varIdxs.get(rv);
            this.extendedValues[idx] = value;
            this.extendedIdx = idx >= this.hiddenStart ? idx : this.hiddenStart - 1;
        }

        public boolean containsValue(RandomVariable rv) {
            return this.varIdxs.get(rv) <= this.extendedIdx;
        }

        public double posteriorForParents(RandomVariable rv) {
            Node n = this.bn.getNode(rv);
            if (!(n instanceof FiniteNode)) {
                throw new IllegalArgumentException("Enumeration-Ask only works with finite Nodes.");
            }
            FiniteNode fn = (FiniteNode)n;
            Object[] vals = new Object[1 + fn.getParents().size()];
            int idx = 0;
            for (Node pn : n.getParents()) {
                vals[idx] = this.extendedValues[this.varIdxs.get(pn.getRandomVariable())];
                ++idx;
            }
            vals[idx] = this.extendedValues[this.varIdxs.get(rv)];
            return fn.getCPT().getValue(vals);
        }
    }
}

