/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.bayes.exact;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.Factor;
import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.BayesInference;
import aima.core.probability.bayes.BayesianNetwork;
import aima.core.probability.bayes.FiniteNode;
import aima.core.probability.bayes.Node;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.util.ProbabilityTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EliminationAsk
implements BayesInference {
    private static final ProbabilityTable _identity = new ProbabilityTable(new double[]{1.0}, new RandomVariable[0]);

    public CategoricalDistribution eliminationAsk(RandomVariable[] X, AssignmentProposition[] e, BayesianNetwork bn) {
        HashSet<RandomVariable> hidden = new HashSet<RandomVariable>();
        ArrayList<RandomVariable> VARS = new ArrayList<RandomVariable>();
        this.calculateVariables(X, e, bn, hidden, VARS);
        List<Factor> factors = new ArrayList<Factor>();
        for (RandomVariable var : this.order(bn, VARS)) {
            factors.add(0, this.makeFactor(var, e, bn));
            if (!hidden.contains(var)) continue;
            factors = this.sumOut(var, factors, bn);
        }
        Factor product = this.pointwiseProduct(factors);
        return ((ProbabilityTable)product.pointwiseProductPOS(_identity, X)).normalize();
    }

    @Override
    public CategoricalDistribution ask(RandomVariable[] X, AssignmentProposition[] observedEvidence, BayesianNetwork bn) {
        return this.eliminationAsk(X, observedEvidence, bn);
    }

    protected void calculateVariables(RandomVariable[] X, AssignmentProposition[] e, BayesianNetwork bn, Set<RandomVariable> hidden, Collection<RandomVariable> bnVARS) {
        bnVARS.addAll(bn.getVariablesInTopologicalOrder());
        hidden.addAll(bnVARS);
        for (RandomVariable x : X) {
            hidden.remove(x);
        }
        for (AssignmentProposition ap : e) {
            hidden.removeAll(ap.getScope());
        }
    }

    protected List<RandomVariable> order(BayesianNetwork bn, Collection<RandomVariable> vars) {
        ArrayList<RandomVariable> order = new ArrayList<RandomVariable>(vars);
        Collections.reverse(order);
        return order;
    }

    private Factor makeFactor(RandomVariable var, AssignmentProposition[] e, BayesianNetwork bn) {
        Node n = bn.getNode(var);
        if (!(n instanceof FiniteNode)) {
            throw new IllegalArgumentException("Elimination-Ask only works with finite Nodes.");
        }
        FiniteNode fn = (FiniteNode)n;
        ArrayList<AssignmentProposition> evidence = new ArrayList<AssignmentProposition>();
        for (AssignmentProposition ap : e) {
            if (!fn.getCPT().contains(ap.getTermVariable())) continue;
            evidence.add(ap);
        }
        return fn.getCPT().getFactorFor(evidence.toArray(new AssignmentProposition[evidence.size()]));
    }

    private List<Factor> sumOut(RandomVariable var, List<Factor> factors, BayesianNetwork bn) {
        ArrayList<Factor> summedOutFactors = new ArrayList<Factor>();
        ArrayList<Factor> toMultiply = new ArrayList<Factor>();
        for (Factor f : factors) {
            if (f.contains(var)) {
                toMultiply.add(f);
                continue;
            }
            summedOutFactors.add(f);
        }
        summedOutFactors.add(this.pointwiseProduct(toMultiply).sumOut(var));
        return summedOutFactors;
    }

    private Factor pointwiseProduct(List<Factor> factors) {
        Factor product = factors.get(0);
        for (int i = 1; i < factors.size(); ++i) {
            product = product.pointwiseProduct(factors.get(i));
        }
        return product;
    }
}

