/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.bayes.approx;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.BayesianNetwork;
import aima.core.probability.bayes.approx.BayesSampleInference;
import aima.core.probability.bayes.approx.PriorSample;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.util.ProbUtil;
import aima.core.probability.util.ProbabilityTable;
import java.util.Map;

public class RejectionSampling
implements BayesSampleInference {
    private PriorSample ps = null;

    public RejectionSampling() {
        this(new PriorSample());
    }

    public RejectionSampling(PriorSample ps) {
        this.ps = ps;
    }

    public CategoricalDistribution rejectionSampling(RandomVariable[] X, AssignmentProposition[] e, BayesianNetwork bn, int Nsamples) {
        double[] N = new double[ProbUtil.expectedSizeOfCategoricalDistribution(X)];
        for (int j = 0; j < Nsamples; ++j) {
            Map<RandomVariable, Object> x = this.ps.priorSample(bn);
            if (!this.isConsistent(x, e)) continue;
            int n = ProbUtil.indexOf(X, x);
            N[n] = N[n] + 1.0;
        }
        return new ProbabilityTable(N, X).normalize();
    }

    @Override
    public CategoricalDistribution ask(RandomVariable[] X, AssignmentProposition[] observedEvidence, BayesianNetwork bn, int N) {
        return this.rejectionSampling(X, observedEvidence, bn, N);
    }

    private boolean isConsistent(Map<RandomVariable, Object> x, AssignmentProposition[] e) {
        for (AssignmentProposition ap : e) {
            if (ap.getValue().equals(x.get(ap.getTermVariable()))) continue;
            return false;
        }
        return true;
    }
}

