/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.bayes.approx;

import aima.core.probability.FiniteProbabilityModel;
import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.DynamicBayesianNetwork;
import aima.core.probability.bayes.approx.PriorSample;
import aima.core.probability.bayes.exact.EliminationAsk;
import aima.core.probability.bayes.model.FiniteBayesModel;
import aima.core.probability.domain.FiniteIntegerDomain;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.util.ProbUtil;
import aima.core.probability.util.RandVar;
import aima.core.util.JavaRandomizer;
import aima.core.util.Randomizer;
import aima.core.util.Util;
import java.util.LinkedHashMap;
import java.util.Map;

public class ParticleFiltering {
    private int N = 0;
    private DynamicBayesianNetwork dbn = null;
    private AssignmentProposition[][] S = new AssignmentProposition[0][0];
    private Randomizer randomizer = null;
    private PriorSample priorSampler = null;
    private AssignmentProposition[][] S_tp1 = new AssignmentProposition[0][0];
    private FiniteProbabilityModel sensorModel = null;
    private RandomVariable sampleIndexes = null;

    public ParticleFiltering(int N, DynamicBayesianNetwork dbn) {
        this(N, dbn, new JavaRandomizer());
    }

    public ParticleFiltering(int N, DynamicBayesianNetwork dbn, Randomizer randomizer) {
        this.randomizer = randomizer;
        this.priorSampler = new PriorSample(this.randomizer);
        this.initPersistent(N, dbn);
    }

    public AssignmentProposition[][] particleFiltering(AssignmentProposition[] e) {
        double[] W = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.sampleFromTransitionModel(i);
            W[i] = this.sensorModel.posterior(ProbUtil.constructConjunction(e), this.S_tp1[i]);
        }
        this.S = this.weightedSampleWithReplacement(this.N, this.S, W);
        return this.S;
    }

    public void initPersistent(int N, DynamicBayesianNetwork dbn) {
        this.N = N;
        this.dbn = dbn;
        this.S = new AssignmentProposition[N][this.dbn.getX_0().size()];
        this.S_tp1 = new AssignmentProposition[N][this.dbn.getX_0().size()];
        Integer[] indexes = new Integer[N];
        for (int i = 0; i < N; ++i) {
            indexes[i] = i;
            Map<RandomVariable, Object> sample = this.priorSampler.priorSample(this.dbn.getPriorNetwork());
            int idx = 0;
            for (Map.Entry<RandomVariable, Object> sa : sample.entrySet()) {
                this.S[i][idx] = new AssignmentProposition(this.dbn.getX_0_to_X_1().get(sa.getKey()), sa.getValue());
                this.S_tp1[i][idx] = new AssignmentProposition(this.dbn.getX_0_to_X_1().get(sa.getKey()), sa.getValue());
                ++idx;
            }
        }
        this.sensorModel = new FiniteBayesModel(dbn, new EliminationAsk());
        this.sampleIndexes = new RandVar("SAMPLE_INDEXES", new FiniteIntegerDomain(indexes));
    }

    private void sampleFromTransitionModel(int i) {
        AssignmentProposition x1;
        LinkedHashMap<RandomVariable, Object> x = new LinkedHashMap<RandomVariable, Object>();
        for (int n = 0; n < this.S[i].length; ++n) {
            x1 = this.S[i][n];
            x.put(this.dbn.getX_1_to_X_0().get(x1.getTermVariable()), x1.getValue());
        }
        for (RandomVariable X1_i : this.dbn.getX_1_VariablesInTopologicalOrder()) {
            x.put(X1_i, ProbUtil.randomSample(this.dbn.getNode(X1_i), x, this.randomizer));
        }
        for (int n = 0; n < this.S_tp1[i].length; ++n) {
            x1 = this.S_tp1[i][n];
            x1.setValue(x.get(x1.getTermVariable()));
        }
    }

    private AssignmentProposition[][] weightedSampleWithReplacement(int N, AssignmentProposition[][] S, double[] W) {
        AssignmentProposition[][] newS = new AssignmentProposition[N][this.dbn.getX_0().size()];
        double[] normalizedW = Util.normalize(W);
        for (int i = 0; i < N; ++i) {
            int sample = (Integer)ProbUtil.sample(this.randomizer.nextDouble(), this.sampleIndexes, normalizedW);
            for (int idx = 0; idx < this.S_tp1[i].length; ++idx) {
                AssignmentProposition ap = this.S_tp1[sample][idx];
                newS[i][idx] = new AssignmentProposition(ap.getTermVariable(), ap.getValue());
            }
        }
        return newS;
    }
}

