/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.bayes.approx;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.BayesianNetwork;
import aima.core.probability.bayes.approx.BayesSampleInference;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.util.ProbUtil;
import aima.core.probability.util.ProbabilityTable;
import aima.core.util.JavaRandomizer;
import aima.core.util.Randomizer;
import aima.core.util.datastructure.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class LikelihoodWeighting
implements BayesSampleInference {
    private Randomizer randomizer = null;

    public LikelihoodWeighting() {
        this(new JavaRandomizer(new Random()));
    }

    public LikelihoodWeighting(Randomizer r) {
        this.randomizer = r;
    }

    public CategoricalDistribution likelihoodWeighting(RandomVariable[] X, AssignmentProposition[] e, BayesianNetwork bn, int N) {
        double[] W = new double[ProbUtil.expectedSizeOfCategoricalDistribution(X)];
        for (int j = 0; j < N; ++j) {
            Pair<Map<RandomVariable, Object>, Double> x_w = this.weightedSample(bn, e);
            int n = ProbUtil.indexOf(X, x_w.getFirst());
            W[n] = W[n] + x_w.getSecond();
        }
        return new ProbabilityTable(W, X).normalize();
    }

    public Pair<Map<RandomVariable, Object>, Double> weightedSample(BayesianNetwork bn, AssignmentProposition[] e) {
        double w = 1.0;
        LinkedHashMap<RandomVariable, Object> x = new LinkedHashMap<RandomVariable, Object>();
        for (AssignmentProposition ap : e) {
            x.put(ap.getTermVariable(), ap.getValue());
        }
        for (RandomVariable Xi : bn.getVariablesInTopologicalOrder()) {
            if (x.containsKey(Xi)) {
                w *= bn.getNode(Xi).getCPD().getValue(ProbUtil.getEventValuesForXiGivenParents(bn.getNode(Xi), x));
                continue;
            }
            x.put(Xi, ProbUtil.randomSample(bn.getNode(Xi), x, this.randomizer));
        }
        return new Pair<Map<RandomVariable, Object>, Double>(x, w);
    }

    @Override
    public CategoricalDistribution ask(RandomVariable[] X, AssignmentProposition[] observedEvidence, BayesianNetwork bn, int N) {
        return this.likelihoodWeighting(X, observedEvidence, bn, N);
    }
}

