/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.bayes.approx;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.BayesianNetwork;
import aima.core.probability.bayes.approx.BayesSampleInference;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.util.ProbUtil;
import aima.core.probability.util.ProbabilityTable;
import aima.core.util.JavaRandomizer;
import aima.core.util.Randomizer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Random;

public class GibbsAsk
implements BayesSampleInference {
    private Randomizer randomizer = null;

    public GibbsAsk() {
        this(new JavaRandomizer(new Random()));
    }

    public GibbsAsk(Randomizer r) {
        this.randomizer = r;
    }

    public CategoricalDistribution gibbsAsk(RandomVariable[] X, AssignmentProposition[] e, BayesianNetwork bn, int Nsamples) {
        double[] N = new double[ProbUtil.expectedSizeOfCategoricalDistribution(X)];
        LinkedHashSet<RandomVariable> Z = new LinkedHashSet<RandomVariable>(bn.getVariablesInTopologicalOrder());
        for (AssignmentProposition ap : e) {
            Z.remove(ap.getTermVariable());
        }
        LinkedHashMap<RandomVariable, Object> x = new LinkedHashMap<RandomVariable, Object>();
        for (AssignmentProposition ap : e) {
            x.put(ap.getTermVariable(), ap.getValue());
        }
        for (RandomVariable Zi : Z) {
            x.put(Zi, ProbUtil.randomSample(bn.getNode(Zi), x, this.randomizer));
        }
        for (int j = 0; j < Nsamples; ++j) {
            for (RandomVariable Zi : Z) {
                x.put(Zi, ProbUtil.mbRandomSample(bn.getNode(Zi), x, this.randomizer));
            }
            int n = ProbUtil.indexOf(X, x);
            N[n] = N[n] + 1.0;
        }
        return new ProbabilityTable(N, X).normalize();
    }

    @Override
    public CategoricalDistribution ask(RandomVariable[] X, AssignmentProposition[] observedEvidence, BayesianNetwork bn, int N) {
        return this.gibbsAsk(X, observedEvidence, bn, N);
    }
}

