/*
 * Decompiled with CFR 0.152.
 */
package aima.core.nlp.ranking;

import aima.core.nlp.ranking.LinkFinder;
import aima.core.nlp.ranking.Page;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiLinkFinder
implements LinkFinder {
    @Override
    public List<String> getOutlinks(Page page) {
        String content = page.getContent();
        ArrayList<String> outLinks = new ArrayList<String>();
        ArrayList<String> allMatches = new ArrayList<String>();
        Matcher m = Pattern.compile("href=\"(/wiki/.*?)\"").matcher(content);
        while (m.find()) {
            allMatches.add(m.group());
        }
        for (int i = 0; i < allMatches.size(); ++i) {
            String match = (String)allMatches.get(i);
            String[] tokens = match.split("\"");
            String location = tokens[1].toLowerCase();
            outLinks.add(location);
        }
        return outLinks;
    }

    @Override
    public List<String> getInlinks(Page target, Map<String, Page> pageTable) {
        String location = target.getLocation().toLowerCase();
        ArrayList<String> inlinks = new ArrayList<String>();
        Iterator<String> keySetIterator = pageTable.keySet().iterator();
        block0: while (keySetIterator.hasNext()) {
            Page p = pageTable.get(keySetIterator.next());
            for (int i = 0; i < p.getOutlinks().size(); ++i) {
                String pForward = p.getOutlinks().get(i).toLowerCase().replace('\\', '/');
                String pBackward = p.getOutlinks().get(i).toLowerCase().replace('/', '\\');
                if (!pForward.equals(location) && !pBackward.equals(location)) continue;
                inlinks.add(p.getLocation().toLowerCase());
                continue block0;
            }
        }
        return inlinks;
    }
}

