/*
 * Decompiled with CFR 0.152.
 */
package aima.core.nlp.ranking;

import aima.core.nlp.ranking.Page;
import aima.core.nlp.ranking.WikiLinkFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PagesDataset {
    static String wikiPagesFolderPath = "src\\main\\resources\\aima\\core\\ranking\\data\\pages";
    static String testFilesFolderPath = "src\\main\\resources\\aima\\core\\ranking\\data\\pages\\test_pages";
    private static WikiLinkFinder wlf;

    public static Map<String, Page> loadDefaultPages() {
        return PagesDataset.loadPages(wikiPagesFolderPath);
    }

    public static Map<String, Page> loadTestPages() {
        return PagesDataset.loadPages(testFilesFolderPath);
    }

    public static Map<String, Page> loadPages(String folderPath) {
        Map<String, Page> pageTable = new Hashtable<String, Page>();
        wlf = new WikiLinkFinder();
        File folder = new File(folderPath);
        if (!folder.exists() || !folder.isDirectory()) {
            return null;
        }
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            File currFile = listOfFiles[i];
            if (!currFile.isFile()) continue;
            Page currPage = PagesDataset.wikiPageFromFile(folder, currFile);
            pageTable.put(currPage.getLocation(), currPage);
        }
        pageTable = PagesDataset.determineAllInlinks(pageTable);
        return pageTable;
    }

    public static Page wikiPageFromFile(File folder, File f) {
        String pageLocation = PagesDataset.getPageName(f);
        String content = PagesDataset.loadFileText(folder, f);
        Page p = new Page(pageLocation);
        p.setContent(content);
        p.getOutlinks().addAll(wlf.getOutlinks(p));
        return p;
    }

    public static Map<String, Page> determineAllInlinks(Map<String, Page> pageTable) {
        Set<String> keySet = pageTable.keySet();
        Iterator<String> keySetIterator = keySet.iterator();
        while (keySetIterator.hasNext()) {
            Page currPage = pageTable.get(keySetIterator.next());
            currPage.getInlinks().addAll(wlf.getInlinks(currPage, pageTable));
        }
        return pageTable;
    }

    public static String getPageName(File f) {
        String wikiPrefix = "/wiki/";
        String filename = f.getName();
        if (filename.indexOf(".") > 0) {
            filename = filename.substring(0, filename.lastIndexOf("."));
        }
        return wikiPrefix + filename.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFileText(File folder, File file) {
        String pageContent = "";
        BufferedReader br = null;
        try {
            String sCurrentLine;
            String folderPath = folder.getAbsolutePath();
            String fileName = file.getName();
            br = new BufferedReader(new FileReader(folderPath + File.separator + fileName));
            while ((sCurrentLine = br.readLine()) != null) {
                pageContent = pageContent + sCurrentLine;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return pageContent;
    }
}

