/*
 * Decompiled with CFR 0.152.
 */
package aima.core.nlp.ranking;

import aima.core.nlp.ranking.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class HITS {
    final int RANK_HISTORY_DEPTH;
    final double DELTA_TOLERANCE;
    Map<String, Page> pTable;
    double[] prevAuthVals;
    double[] prevHubVals;
    double prevAveHubDelta = 0.0;
    double prevAveAuthDelta = 0.0;

    public HITS(Map<String, Page> pTable, int rank_hist_depth, double delta_tolerance) {
        this.pTable = pTable;
        this.RANK_HISTORY_DEPTH = rank_hist_depth;
        this.DELTA_TOLERANCE = delta_tolerance;
    }

    public HITS(Map<String, Page> pTable) {
        this(pTable, 3, 0.05);
    }

    public List<Page> hits(String query) {
        List<Page> pages = this.expandPages(this.relevantPages(query));
        for (Page p : pages) {
            p.authority = 1.0;
            p.hub = 1.0;
        }
        while (!this.convergence(pages)) {
            for (Page p : pages) {
                p.authority = this.SumInlinkHubScore(p);
                p.hub = this.SumOutlinkAuthorityScore(p);
            }
            this.normalize(pages);
        }
        return pages;
    }

    public List<Page> relevantPages(String query) {
        ArrayList<Page> relevantPages = new ArrayList<Page>();
        for (Page p : this.pTable.values()) {
            if (!this.matches(query, p.getContent())) continue;
            relevantPages.add(p);
        }
        return relevantPages;
    }

    public boolean matches(String query, String text) {
        return text.contains(query);
    }

    public List<Page> expandPages(List<Page> pages) {
        ArrayList<Page> expandedPages = new ArrayList<Page>();
        HashSet<String> inAndOutLinks = new HashSet<String>();
        for (int i = 0; i < pages.size(); ++i) {
            Page currP = pages.get(i);
            if (!expandedPages.contains(currP)) {
                expandedPages.add(currP);
            }
            List<String> currInlinks = currP.getInlinks();
            for (int j = 0; j < currInlinks.size(); ++j) {
                inAndOutLinks.add(currInlinks.get(i));
            }
            List<String> currOutlinks = currP.getOutlinks();
            for (int j = 0; j < currOutlinks.size(); ++j) {
                inAndOutLinks.add(currOutlinks.get(i));
            }
        }
        for (String addr : inAndOutLinks) {
            Page p = this.pTable.get(addr);
            if (p == null || expandedPages.contains(p)) continue;
            expandedPages.add(p);
        }
        return expandedPages;
    }

    public List<Page> normalize(List<Page> pages) {
        double hubTotal = 0.0;
        double authTotal = 0.0;
        for (Page p : pages) {
            hubTotal += Math.pow(p.hub, 2.0);
            authTotal += Math.pow(p.authority, 2.0);
        }
        for (Page p : pages) {
            p.hub = hubTotal > 0.0 ? (p.hub /= hubTotal) : 0.0;
            if (authTotal > 0.0) {
                p.authority /= authTotal;
                continue;
            }
            p.authority = 0.0;
        }
        return pages;
    }

    public double SumInlinkHubScore(Page page) {
        List<String> inLinks = page.getInlinks();
        double hubScore = 0.0;
        for (int i = 0; i < inLinks.size(); ++i) {
            Page inLink = this.pTable.get(inLinks.get(i));
            if (inLink == null) continue;
            hubScore += inLink.hub;
        }
        return hubScore;
    }

    public double SumOutlinkAuthorityScore(Page page) {
        List<String> outLinks = page.getOutlinks();
        double authScore = 0.0;
        for (int i = 0; i < outLinks.size(); ++i) {
            Page outLink = this.pTable.get(outLinks.get(i));
            if (outLink == null) continue;
            authScore += outLink.authority;
        }
        return authScore;
    }

    private boolean convergence(List<Page> pages) {
        double aveHubDelta = 100.0;
        double aveAuthDelta = 100.0;
        if (pages == null) {
            return true;
        }
        double[] currHubVals = new double[pages.size()];
        double[] currAuthVals = new double[pages.size()];
        for (int i = 0; i < pages.size(); ++i) {
            Page currPage = pages.get(i);
            currHubVals[i] = currPage.hub;
            currHubVals[i] = currPage.authority;
        }
        if (this.prevHubVals == null || this.prevAuthVals == null) {
            this.prevHubVals = currHubVals;
            this.prevAuthVals = currAuthVals;
            return false;
        }
        aveHubDelta = this.getAveDelta(currHubVals, this.prevHubVals);
        if (aveHubDelta + (aveAuthDelta = this.getAveDelta(currAuthVals, this.prevAuthVals)) < this.DELTA_TOLERANCE || Math.abs(this.prevAveHubDelta - aveHubDelta) < 0.01 && Math.abs(this.prevAveAuthDelta - aveAuthDelta) < 0.01) {
            return true;
        }
        this.prevHubVals = currHubVals;
        this.prevAuthVals = currAuthVals;
        this.prevAveHubDelta = aveHubDelta;
        this.prevAveAuthDelta = aveAuthDelta;
        return false;
    }

    public double getAveDelta(double[] curr, double[] prev) {
        double aveDelta = 0.0;
        assert (curr.length == prev.length);
        for (int j = 0; j < curr.length; ++j) {
            aveDelta += Math.abs(curr[j] - prev[j]);
        }
        return aveDelta /= (double)curr.length;
    }

    public Page getMaxHub(List<Page> result) {
        Page maxHub = result.get(0);
        for (int i = 1; i < result.size(); ++i) {
            Page currPage = result.get(i);
            if (!(currPage.hub > maxHub.hub)) continue;
            maxHub = currPage;
        }
        return maxHub;
    }

    public Page getMaxAuthority(List<Page> result) {
        Page maxAuthority = result.get(0);
        for (int i = 1; i < result.size(); ++i) {
            Page currPage = result.get(i);
            if (!(currPage.authority > maxAuthority.authority)) continue;
            maxAuthority = currPage;
        }
        return maxAuthority;
    }

    public void sortHub(List<Page> result) {
        Collections.sort(result, new Comparator<Page>(){

            @Override
            public int compare(Page p1, Page p2) {
                return p1.hub < p2.hub ? -1 : (p1.hub > p2.hub ? 1 : this.secondaryOrderSort(p1, p2));
            }

            public int secondaryOrderSort(Page p1, Page p2) {
                return p1.getLocation().compareToIgnoreCase(p2.getLocation()) < 1 ? -1 : (p1.getLocation().compareToIgnoreCase(p2.getLocation()) > 1 ? 1 : 0);
            }
        });
    }

    public void sortAuthority(List<Page> result) {
        Collections.sort(result, new Comparator<Page>(){

            @Override
            public int compare(Page p1, Page p2) {
                return p1.hub < p2.hub ? -1 : (p1.hub > p2.hub ? 1 : this.secondaryOrderSort(p1, p2));
            }

            public int secondaryOrderSort(Page p1, Page p2) {
                return p1.getLocation().compareToIgnoreCase(p2.getLocation()) < 1 ? -1 : (p1.getLocation().compareToIgnoreCase(p2.getLocation()) > 1 ? 1 : 0);
            }
        });
    }

    public void report(List<Page> result) {
        Page currP;
        int i;
        this.sortAuthority(result);
        System.out.println("AUTHORITY RANKINGS : ");
        for (i = 0; i < result.size(); ++i) {
            currP = result.get(i);
            System.out.printf(currP.getLocation() + ": %.5f" + '\n', currP.authority);
        }
        System.out.println();
        this.sortHub(result);
        System.out.println("HUB RANKINGS : ");
        for (i = 0; i < result.size(); ++i) {
            currP = result.get(i);
            System.out.printf(currP.getLocation() + ": %.5f" + '\n', currP.hub);
        }
        System.out.println();
        System.out.println("Page with highest Authority score: " + this.getMaxAuthority(result).getLocation());
        System.out.println("Page with highest Hub score: " + this.getMaxAuthority(result).getLocation());
    }
}

