/*
 * Decompiled with CFR 0.152.
 */
package aima.core.nlp.parsing.grammars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Rule {
    public final float PROB;
    public final List<String> lhs;
    public final List<String> rhs;

    public Rule(List<String> lhs, List<String> rhs, float probability) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.PROB = this.validateProb(probability);
    }

    public Rule(List<String> lhs, float probability) {
        this.lhs = lhs;
        this.rhs = null;
        this.PROB = this.validateProb(probability);
    }

    public Rule(String lhs, String rhs, float probability) {
        this.lhs = lhs.equals("") ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(lhs.split("\\s*,\\s*")));
        this.rhs = rhs.equals("") ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(rhs.split("\\s*,\\s*")));
        this.PROB = this.validateProb(probability);
    }

    private float validateProb(float prob) {
        if ((double)prob >= 0.0 && (double)prob <= 1.0) {
            return prob;
        }
        return 0.5f;
    }

    public boolean derives(List<String> sentForm) {
        if (this.rhs.size() != sentForm.size()) {
            return false;
        }
        for (int i = 0; i < sentForm.size(); ++i) {
            if (this.rhs.get(i) == sentForm.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean derives(String terminal) {
        return this.rhs.size() == 1 && this.rhs.get(0).equals(terminal);
    }

    public String toString() {
        int i;
        String output = "";
        for (i = 0; i < this.lhs.size(); ++i) {
            output = output + this.lhs.get(i);
        }
        output = output + " -> ";
        for (i = 0; i < this.rhs.size(); ++i) {
            output = output + this.rhs.get(i);
        }
        output = output + " " + String.valueOf(this.PROB);
        return output;
    }
}

