/*
 * Decompiled with CFR 0.152.
 */
package aima.core.nlp.parsing.grammars;

import aima.core.nlp.parsing.grammars.ProbabilisticGrammar;
import aima.core.nlp.parsing.grammars.Rule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProbUnrestrictedGrammar
implements ProbabilisticGrammar {
    public static final int UNRESTRICTED = 0;
    public static final int CONTEXT_SENSITIVE = 1;
    public static final int CONTEXT_FREE = 2;
    public static final int REGULAR = 3;
    public static final int CNFGRAMMAR = 4;
    public static final int PROB_CONTEXT_FREE = 5;
    public List<Rule> rules = new ArrayList<Rule>();
    public List<String> vars = new ArrayList<String>();
    public List<String> terminals = new ArrayList<String>();
    public int type = 0;

    @Override
    public boolean addRules(List<Rule> ruleList) {
        for (int i = 0; i < ruleList.size(); ++i) {
            if (this.validRule(ruleList.get(i))) continue;
            return false;
        }
        if (!this.validateRuleProbabilities(ruleList)) {
            return false;
        }
        this.rules = ruleList;
        this.updateVarsAndTerminals();
        return true;
    }

    @Override
    public boolean addRule(Rule rule) {
        if (this.validRule(rule)) {
            this.rules.add(rule);
            this.updateVarsAndTerminals(rule);
            return true;
        }
        return false;
    }

    @Override
    public boolean validateRuleProbabilities(List<Rule> ruleList) {
        float probTotal = 0.0f;
        for (int i = 0; i < this.vars.size(); ++i) {
            for (int j = 0; j < ruleList.size(); ++j) {
                if (j == 0) {
                    probTotal = 0.0f;
                }
                if (ruleList.get((int)i).lhs.get(0).equals(this.vars.get(i))) {
                    probTotal += ruleList.get((int)i).PROB;
                }
                if ((double)probTotal > 1.0) {
                    return false;
                }
                if (j != ruleList.size() - 1 || probTotal == 1.0f) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean validRule(Rule r) {
        return r.lhs != null && r.lhs.size() > 0;
    }

    @Override
    public void updateVarsAndTerminals() {
        if (this.rules == null) {
            this.vars = new ArrayList<String>();
            this.terminals = new ArrayList<String>();
            return;
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule r = this.rules.get(i);
            this.updateVarsAndTerminals(r);
        }
    }

    @Override
    public void updateVarsAndTerminals(Rule r) {
        int j;
        for (j = 0; j < r.lhs.size(); ++j) {
            if (ProbUnrestrictedGrammar.isVariable(r.lhs.get(j)) && !this.vars.contains(r.lhs.get(j))) {
                this.vars.add(r.lhs.get(j));
                continue;
            }
            if (!ProbUnrestrictedGrammar.isTerminal(r.lhs.get(j)) || this.terminals.contains(r.lhs.get(j))) continue;
            this.terminals.add(r.lhs.get(j));
        }
        if (r.rhs != null) {
            for (j = 0; j < r.rhs.size(); ++j) {
                if (ProbUnrestrictedGrammar.isVariable(r.rhs.get(j)) && !this.vars.contains(r.rhs.get(j))) {
                    this.vars.add(r.rhs.get(j));
                    continue;
                }
                if (!ProbUnrestrictedGrammar.isTerminal(r.rhs.get(j)) || this.terminals.contains(r.rhs.get(j))) continue;
                this.terminals.add(r.rhs.get(j));
            }
        }
        Collections.sort(this.vars);
        Collections.sort(this.terminals);
    }

    public static boolean isVariable(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isTerminal(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isLowerCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int i;
        String output = "";
        output = output + "Variables:  ";
        for (i = 0; i < this.vars.size(); ++i) {
            output = output + this.vars.get(i) + ", ";
        }
        output = output + '\n';
        output = output + "Terminals:  ";
        for (i = 0; i < this.terminals.size(); ++i) {
            output = output + this.terminals.get(i) + ", ";
        }
        output = output + '\n';
        for (i = 0; i < this.rules.size(); ++i) {
            output = output + this.rules.get(i).toString() + '\n';
        }
        return output;
    }
}

