/*
 * Decompiled with CFR 0.152.
 */
package aima.core.nlp.parsing;

import aima.core.nlp.parsing.LexWord;
import aima.core.nlp.parsing.grammars.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Lexicon
extends HashMap<String, ArrayList<LexWord>> {
    private static final long serialVersionUID = 1L;

    public ArrayList<Rule> getTerminalRules(String partOfSpeech) {
        ArrayList lexWords = (ArrayList)this.get(partOfSpeech.toUpperCase());
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (lexWords.size() > 0) {
            for (int i = 0; i < lexWords.size(); ++i) {
                rules.add(new Rule(partOfSpeech.toUpperCase(), ((LexWord)lexWords.get((int)i)).word, ((LexWord)lexWords.get((int)i)).prob.floatValue()));
            }
        }
        return rules;
    }

    public ArrayList<Rule> getAllTerminalRules() {
        ArrayList<Rule> allRules = new ArrayList<Rule>();
        Set keys = this.keySet();
        for (String key : keys) {
            allRules.addAll(this.getTerminalRules(key));
        }
        return allRules;
    }

    public boolean addEntry(String category, String word, float prob) {
        if (this.containsKey(category)) {
            ((ArrayList)this.get(category)).add(new LexWord(word, Float.valueOf(prob)));
        } else {
            this.put(category, new ArrayList<LexWord>(Arrays.asList(new LexWord(word, Float.valueOf(prob)))));
        }
        return true;
    }

    public boolean addLexWords(String ... vargs) {
        ArrayList<LexWord> lexWords = new ArrayList<LexWord>();
        boolean containsKey = false;
        if (vargs.length % 2 != 1) {
            return false;
        }
        String key = vargs[0].toUpperCase();
        if (this.containsKey(key)) {
            containsKey = true;
        }
        for (int i = 1; i < vargs.length; ++i) {
            try {
                if (containsKey) {
                    ((ArrayList)this.get(key)).add(new LexWord(vargs[i], Float.valueOf(vargs[i + 1])));
                } else {
                    lexWords.add(new LexWord(vargs[i], Float.valueOf(vargs[i + 1])));
                }
                ++i;
                continue;
            }
            catch (NumberFormatException e) {
                System.err.println("Supplied args have incorrect format.");
                return false;
            }
        }
        if (!containsKey) {
            this.put(key, lexWords);
        }
        return true;
    }

    public void addLexWords(Lexicon l) {
        for (Map.Entry pair : l.entrySet()) {
            if (this.containsKey(pair.getKey())) {
                for (int i = 0; i < ((ArrayList)pair.getValue()).size(); ++i) {
                    ((ArrayList)this.get(pair.getKey())).add(((ArrayList)pair.getValue()).get(i));
                }
                continue;
            }
            this.put(pair.getKey(), pair.getValue());
        }
    }
}

