/*
 * Decompiled with CFR 0.152.
 */
package aima.core.nlp.parsing;

import aima.core.nlp.parsing.grammars.ProbCNFGrammar;
import aima.core.nlp.parsing.grammars.ProbUnrestrictedGrammar;
import aima.core.nlp.parsing.grammars.Rule;
import java.util.ArrayList;
import java.util.List;

public class CYK {
    public float[][][] parse(List<String> words, ProbCNFGrammar grammar) {
        int N = this.length(words);
        int M = grammar.vars.size();
        float[][][] P = new float[M][N][N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < grammar.rules.size(); ++j) {
                Rule r = (Rule)grammar.rules.get(j);
                if (!r.derives(words.get(i))) continue;
                int x = grammar.vars.indexOf(r.lhs.get(0));
                P[x][i][0] = r.PROB;
            }
        }
        for (int length = 2; length <= N; ++length) {
            for (int start = 1; start <= N - length + 1; ++start) {
                for (int len1 = 1; len1 <= length - 1; ++len1) {
                    int len2 = length - len1;
                    for (int j = 0; j < grammar.rules.size(); ++j) {
                        Rule r = (Rule)grammar.rules.get(j);
                        if (r.rhs.size() != 2) continue;
                        int x = grammar.vars.indexOf(r.lhs.get(0));
                        int y = grammar.vars.indexOf(r.rhs.get(0));
                        int z = grammar.vars.indexOf(r.rhs.get(1));
                        P[x][start - 1][length - 1] = Math.max(P[x][start - 1][length - 1], P[y][start - 1][len1 - 1] * P[z][start + len1 - 1][len2 - 1] * r.PROB);
                    }
                }
            }
        }
        return P;
    }

    public int length(List<String> ls) {
        return ls.size();
    }

    public void printProbTable(float[][][] probTable, List<String> words, ProbUnrestrictedGrammar g) {
        int N = words.size();
        int M = g.vars.size();
        for (int i = 0; i < M; ++i) {
            System.out.println("Table For : " + g.vars.get(i) + "(" + i + ")");
            for (int j = 0; j < N; ++j) {
                System.out.print(j + "| ");
                for (int k = 0; k < N; ++k) {
                    System.out.print(probTable[i][j][k] + " | ");
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    public ArrayList<String> getMostProbableDerivation(float[][][] probTable, ProbUnrestrictedGrammar g) {
        return null;
    }
}

