/*
 * Decompiled with CFR 0.152.
 */
package aima.core.nlp.data.lexicons;

import aima.core.nlp.parsing.LexWord;
import aima.core.nlp.parsing.Lexicon;
import java.util.ArrayList;

public class LexiconExamples {
    public static Lexicon buildWumpusLex() {
        Lexicon l = new Lexicon();
        ArrayList<LexWord> list = new ArrayList<LexWord>();
        list.add(new LexWord("stench", Float.valueOf(0.05f)));
        list.add(new LexWord("breeze", Float.valueOf(0.1f)));
        list.add(new LexWord("wumpus", Float.valueOf(0.15f)));
        list.add(new LexWord("pits", Float.valueOf(0.05f)));
        list.add(new LexWord("friend", Float.valueOf(0.1f)));
        list.add(new LexWord("enemy", Float.valueOf(0.1f)));
        list.add(new LexWord("dog", Float.valueOf(0.1f)));
        list.add(new LexWord("superhero", Float.valueOf(0.2f)));
        list.add(new LexWord("virus", Float.valueOf(0.15f)));
        l.put("NOUN", list);
        ArrayList<LexWord> verbList = new ArrayList<LexWord>();
        verbList.add(new LexWord("is", Float.valueOf(0.1f)));
        verbList.add(new LexWord("feel", Float.valueOf(0.1f)));
        verbList.add(new LexWord("smells", Float.valueOf(0.1f)));
        verbList.add(new LexWord("stinks", Float.valueOf(0.05f)));
        verbList.add(new LexWord("wants", Float.valueOf(0.2f)));
        verbList.add(new LexWord("flies", Float.valueOf(0.1f)));
        verbList.add(new LexWord("keeps", Float.valueOf(0.05f)));
        verbList.add(new LexWord("leaves", Float.valueOf(0.1f)));
        verbList.add(new LexWord("throws", Float.valueOf(0.2f)));
        l.put("VERB", verbList);
        ArrayList<LexWord> adjList = new ArrayList<LexWord>();
        adjList.add(new LexWord("right", Float.valueOf(0.1f)));
        adjList.add(new LexWord("dead", Float.valueOf(0.05f)));
        adjList.add(new LexWord("smelly", Float.valueOf(0.02f)));
        adjList.add(new LexWord("breezy", Float.valueOf(0.02f)));
        adjList.add(new LexWord("foul", Float.valueOf(0.1f)));
        adjList.add(new LexWord("black", Float.valueOf(0.05f)));
        adjList.add(new LexWord("white", Float.valueOf(0.05f)));
        adjList.add(new LexWord("callous", Float.valueOf(0.1f)));
        adjList.add(new LexWord("proud", Float.valueOf(0.1f)));
        adjList.add(new LexWord("right", Float.valueOf(0.1f)));
        adjList.add(new LexWord("gold", Float.valueOf(0.06f)));
        adjList.add(new LexWord("normal", Float.valueOf(0.25f)));
        l.put("ADJS", adjList);
        l.addLexWords("ADVERB", "here", "0.05", "ahead", "0.05", "nearby", "0.02", "quickly", "0.05", "badly", "0.05", "slowly", "0.08", "sadly", "0.10", "silently", "0.10", "easily", "0.10", "seldom", "0.10", "sometimes", "0.10", "loudly", "0.10", "cordially", "0.05", "frequently", "0.05");
        l.addLexWords("PRONOUN", "me", "0.10", "you", "0.03", "i", "0.10", "it", "0.10", "us", "0.07", "they", "0.20", "he", "0.20", "she", "0.20");
        l.addLexWords("RELPRO", "that", "0.40", "which", "0.15", "who", "0.20", "whom", "0.02", "whose", "0.08", "whabt", "0.15");
        l.addLexWords(LexiconExamples.buildNameLexicon());
        l.addLexWords("ARTICLE", "the", "0.40", "a", "0.30", "an", "0.10", "every", "0.05", "some", "0.15");
        l.addLexWords("PREP", "to", "0.20", "in", "0.10", "on", "0.05", "near", "0.10", "after", "0.10", "among", "0.05", "around", "0.20", "against", "0.10", "across", "0.10");
        l.addLexWords("CONJ", "and", "0.50", "or", "0.10", "but", "0.20", "yet", "0.02", "since", "0.08", "unless", "0.10");
        l.addLexWords("DIGIT", "0", "0.20", "1", "0.20", "2", "0.20", "3", "0.20", "4", "0.20");
        return l;
    }

    public static Lexicon buildNameLexicon() {
        Lexicon l = new Lexicon();
        String[] names = new String[]{"John", "Mary", "Boston", "Xiao", "Hollie", "Kendrick", "Beverly", "Garnet", "Zora", "Shavonda", "Peg", "Katherin", "Beatriz", "Deirdre", "Gaylord", "Desirae", "Tresa", "Gwyneth", "Rashida", "Garfield", "Pinkie", "Claretta", "Teressa", "Andy", "Eugena", "Carie", "Dinorah", "Tess", "Johnie", "Keely", "Antonetta", "Darcey", "Bud", "Veta", "Janey", "Rosalina", "Frederica", "Lou", "Essie", "Marinda", "Elene", "Juliana", "Marilyn", "Maxima", "Branden", "Ethan", "Donovan", "Erinn", "Ramon", "Jacquiline"};
        for (int i = 0; i < names.length; ++i) {
            l.addLexWords("NAME", names[i], "0.02");
        }
        return l;
    }

    public static Lexicon buildTrivialLexicon() {
        Lexicon l = new Lexicon();
        l.addLexWords("ARTICLE", "the", "0.50", "a", "0.50");
        l.addLexWords("NOUN", "man", "0.20", "woman", "0.20", "table", "0.20", "shoelace", "0.20", "saw", "0.20");
        l.addLexWords("PRONOUN", "i", "0.40", "you", "0.40", "it", "0.20");
        l.addLexWords("VERB", "saw", "0.30", "liked", "0.30", "feel", "0.40");
        l.addLexWords("ADVERB", "happily", "0.30", "sadly", "0.20", "morosely", "0.50");
        return l;
    }
}

