/*
 * Decompiled with CFR 0.152.
 */
package aima.core.nlp.data.grammars;

import aima.core.nlp.data.lexicons.LexiconExamples;
import aima.core.nlp.parsing.Lexicon;
import aima.core.nlp.parsing.grammars.ProbCNFGrammar;
import aima.core.nlp.parsing.grammars.Rule;
import java.util.ArrayList;

public class ProbCNFGrammarExamples {
    public static ProbCNFGrammar buildExampleGrammarOne() {
        ProbCNFGrammar g = new ProbCNFGrammar();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(new Rule("S", "Y,Z", 0.1f));
        rules.add(new Rule("B", "B,D", 0.1f));
        rules.add(new Rule("B", "G,D", 0.1f));
        rules.add(new Rule("C", "E,C", 0.1f));
        rules.add(new Rule("C", "E,H", 0.1f));
        rules.add(new Rule("E", "M,N", 0.1f));
        rules.add(new Rule("D", "M,N", 0.1f));
        rules.add(new Rule("Y", "E,C", 0.1f));
        rules.add(new Rule("Z", "E,C", 0.1f));
        rules.add(new Rule("M", "m", 1.0f));
        rules.add(new Rule("N", "n", 1.0f));
        rules.add(new Rule("B", "a", 0.25f));
        rules.add(new Rule("B", "b", 0.25f));
        rules.add(new Rule("B", "c", 0.25f));
        rules.add(new Rule("B", "d", 0.25f));
        rules.add(new Rule("G", "a", 0.5f));
        rules.add(new Rule("G", "d", 0.5f));
        rules.add(new Rule("C", "x", 0.2f));
        rules.add(new Rule("C", "y", 0.2f));
        rules.add(new Rule("C", "z", 0.6f));
        rules.add(new Rule("H", "u", 0.5f));
        rules.add(new Rule("H", "z", 0.5f));
        if (!g.addRules(rules)) {
            return null;
        }
        return g;
    }

    public static ProbCNFGrammar buildTrivialGrammar() {
        ProbCNFGrammar g = new ProbCNFGrammar();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(new Rule("S", "NP,VP", 1.0f));
        rules.add(new Rule("NP", "ARTICLE,NOUN", 0.5f));
        rules.add(new Rule("NP", "PRONOUN,ADVERB", 0.5f));
        rules.add(new Rule("VP", "VERB,NP", 1.0f));
        Lexicon trivLex = LexiconExamples.buildTrivialLexicon();
        ArrayList<Rule> terminalRules = new ArrayList<Rule>(trivLex.getAllTerminalRules());
        rules.addAll(terminalRules);
        if (!g.addRules(rules)) {
            return null;
        }
        return g;
    }
}

