/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.visitors;

import aima.core.logic.propositional.parsing.AbstractPLVisitor;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.Sentence;

public class MoveNotInwards
extends AbstractPLVisitor<Object> {
    public static Sentence moveNotsInward(Sentence sentence) {
        Sentence result = null;
        MoveNotInwards moveNotsIn = new MoveNotInwards();
        result = sentence.accept(moveNotsIn, null);
        return result;
    }

    @Override
    public Sentence visitUnarySentence(ComplexSentence s, Object arg) {
        Sentence result = null;
        Sentence negated = s.getSimplerSentence(0);
        if (negated.isPropositionSymbol()) {
            result = s;
        } else if (negated.isNotSentence()) {
            Sentence alpha = negated.getSimplerSentence(0);
            result = alpha.accept(this, arg);
        } else if (negated.isAndSentence() || negated.isOrSentence()) {
            Sentence alpha = negated.getSimplerSentence(0);
            Sentence beta = negated.getSimplerSentence(1);
            Sentence notAlpha = new ComplexSentence(Connective.NOT, alpha).accept(this, null);
            Sentence notBeta = new ComplexSentence(Connective.NOT, beta).accept(this, null);
            result = negated.isAndSentence() ? new ComplexSentence(Connective.OR, notAlpha, notBeta) : new ComplexSentence(Connective.AND, notAlpha, notBeta);
        } else {
            throw new IllegalArgumentException("Biconditionals and Implications should not exist in input: " + s);
        }
        return result;
    }
}

