/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.visitors;

import aima.core.logic.propositional.kb.data.Clause;
import aima.core.logic.propositional.kb.data.Literal;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.logic.propositional.parsing.ast.Sentence;
import aima.core.logic.propositional.visitors.BasicGatherer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class ClauseCollector
extends BasicGatherer<Clause> {
    public static Set<Clause> getClausesFrom(Sentence ... cnfSentences) {
        Set<Clause> result = new LinkedHashSet<Clause>();
        ClauseCollector clauseCollector = new ClauseCollector();
        for (Sentence cnfSentence : cnfSentences) {
            result = cnfSentence.accept(clauseCollector, result);
        }
        return result;
    }

    @Override
    public Set<Clause> visitPropositionSymbol(PropositionSymbol s, Set<Clause> arg) {
        Literal positiveLiteral = new Literal(s);
        arg.add(new Clause(positiveLiteral));
        return arg;
    }

    @Override
    public Set<Clause> visitUnarySentence(ComplexSentence s, Set<Clause> arg) {
        if (!s.getSimplerSentence(0).isPropositionSymbol()) {
            throw new IllegalStateException("Sentence is not in CNF: " + s);
        }
        Literal negativeLiteral = new Literal((PropositionSymbol)s.getSimplerSentence(0), false);
        arg.add(new Clause(negativeLiteral));
        return arg;
    }

    @Override
    public Set<Clause> visitBinarySentence(ComplexSentence s, Set<Clause> arg) {
        if (s.isAndSentence()) {
            s.getSimplerSentence(0).accept(this, arg);
            s.getSimplerSentence(1).accept(this, arg);
        } else if (s.isOrSentence()) {
            ArrayList<Literal> literals = new ArrayList<Literal>(LiteralCollector.getLiterals(s));
            arg.add(new Clause(literals));
        } else {
            throw new IllegalArgumentException("Sentence is not in CNF: " + s);
        }
        return arg;
    }

    private static class LiteralCollector
    extends BasicGatherer<Literal> {
        private LiteralCollector() {
        }

        private static Set<Literal> getLiterals(Sentence disjunctiveSentence) {
            LinkedHashSet<Literal> result = new LinkedHashSet();
            LiteralCollector literalCollector = new LiteralCollector();
            result = disjunctiveSentence.accept(literalCollector, result);
            return result;
        }

        @Override
        public Set<Literal> visitPropositionSymbol(PropositionSymbol s, Set<Literal> arg) {
            Literal positiveLiteral = new Literal(s);
            arg.add(positiveLiteral);
            return arg;
        }

        @Override
        public Set<Literal> visitUnarySentence(ComplexSentence s, Set<Literal> arg) {
            if (!s.getSimplerSentence(0).isPropositionSymbol()) {
                throw new IllegalStateException("Sentence is not in CNF: " + s);
            }
            Literal negativeLiteral = new Literal((PropositionSymbol)s.getSimplerSentence(0), false);
            arg.add(negativeLiteral);
            return arg;
        }

        @Override
        public Set<Literal> visitBinarySentence(ComplexSentence s, Set<Literal> arg) {
            if (!s.isOrSentence()) {
                throw new IllegalArgumentException("Sentence is not in CNF: " + s);
            }
            s.getSimplerSentence(0).accept(this, arg);
            s.getSimplerSentence(1).accept(this, arg);
            return arg;
        }
    }
}

