/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.visitors;

import aima.core.logic.propositional.parsing.AbstractPLVisitor;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.Sentence;

public class BiconditionalElimination
extends AbstractPLVisitor<Object> {
    public static Sentence eliminate(Sentence sentence) {
        BiconditionalElimination eliminator = new BiconditionalElimination();
        Sentence result = sentence.accept(eliminator, null);
        return result;
    }

    @Override
    public Sentence visitBinarySentence(ComplexSentence s, Object arg) {
        Object result = null;
        if (s.isBiconditionalSentence()) {
            Sentence alpha = s.getSimplerSentence(0).accept(this, arg);
            Sentence beta = s.getSimplerSentence(1).accept(this, arg);
            ComplexSentence alphaImpliesBeta = new ComplexSentence(Connective.IMPLICATION, alpha, beta);
            ComplexSentence betaImpliesAlpha = new ComplexSentence(Connective.IMPLICATION, beta, alpha);
            result = new ComplexSentence(Connective.AND, alphaImpliesBeta, betaImpliesAlpha);
        } else {
            result = super.visitBinarySentence(s, arg);
        }
        return result;
    }
}

