/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.parsing.ast;

import aima.core.logic.common.ParseTreeNode;
import aima.core.logic.propositional.parsing.PLVisitor;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.util.Util;
import java.util.Arrays;
import java.util.List;

public abstract class Sentence
implements ParseTreeNode {
    public Connective getConnective() {
        return null;
    }

    public int getNumberSimplerSentences() {
        return 0;
    }

    public Sentence getSimplerSentence(int offset) {
        return null;
    }

    public boolean isNotSentence() {
        return this.hasConnective(Connective.NOT);
    }

    public boolean isAndSentence() {
        return this.hasConnective(Connective.AND);
    }

    public boolean isOrSentence() {
        return this.hasConnective(Connective.OR);
    }

    public boolean isImplicationSentence() {
        return this.hasConnective(Connective.IMPLICATION);
    }

    public boolean isBiconditionalSentence() {
        return this.hasConnective(Connective.BICONDITIONAL);
    }

    public boolean isPropositionSymbol() {
        return this.getConnective() == null;
    }

    public boolean isUnarySentence() {
        return this.hasConnective(Connective.NOT);
    }

    public boolean isBinarySentence() {
        return this.getConnective() != null && !this.hasConnective(Connective.NOT);
    }

    public <A, R> R accept(PLVisitor<A, R> plv, A arg) {
        R result = null;
        if (this.isPropositionSymbol()) {
            result = plv.visitPropositionSymbol((PropositionSymbol)this, arg);
        } else if (this.isUnarySentence()) {
            result = plv.visitUnarySentence((ComplexSentence)this, arg);
        } else if (this.isBinarySentence()) {
            result = plv.visitBinarySentence((ComplexSentence)this, arg);
        }
        return result;
    }

    public String bracketSentenceIfNecessary(Connective parentConnective, Sentence childSentence) {
        ComplexSentence cs;
        String result = null;
        if (childSentence instanceof ComplexSentence && (cs = (ComplexSentence)childSentence).getConnective().getPrecedence() < parentConnective.getPrecedence()) {
            result = "(" + childSentence + ")";
        }
        if (result == null) {
            result = childSentence.toString();
        }
        return result;
    }

    public static Sentence newDisjunction(Sentence ... disjuncts) {
        return Sentence.newDisjunction(Arrays.asList(disjuncts));
    }

    public static Sentence newDisjunction(List<? extends Sentence> disjuncts) {
        if (disjuncts.size() == 0) {
            return PropositionSymbol.FALSE;
        }
        if (disjuncts.size() == 1) {
            return disjuncts.get(0);
        }
        return new ComplexSentence(Util.first(disjuncts), Connective.OR, Sentence.newDisjunction(Util.rest(disjuncts)));
    }

    public static Sentence newConjunction(Sentence ... conjuncts) {
        return Sentence.newConjunction(Arrays.asList(conjuncts));
    }

    public static Sentence newConjunction(List<? extends Sentence> conjuncts) {
        if (conjuncts.size() == 0) {
            return PropositionSymbol.TRUE;
        }
        if (conjuncts.size() == 1) {
            return conjuncts.get(0);
        }
        return new ComplexSentence(Util.first(conjuncts), Connective.AND, Sentence.newConjunction(Util.rest(conjuncts)));
    }

    protected boolean hasConnective(Connective connective) {
        return this.getConnective() == connective;
    }
}

