/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.parsing.ast;

import aima.core.logic.propositional.parsing.ast.AtomicSentence;
import javax.lang.model.SourceVersion;

public class PropositionSymbol
extends AtomicSentence {
    public static final String TRUE_SYMBOL = "True";
    public static final String FALSE_SYMBOL = "False";
    public static final PropositionSymbol TRUE = new PropositionSymbol("True");
    public static final PropositionSymbol FALSE = new PropositionSymbol("False");
    private String symbol;

    public PropositionSymbol(String symbol) {
        if (TRUE_SYMBOL.equalsIgnoreCase(symbol)) {
            this.symbol = TRUE_SYMBOL;
        } else if (FALSE_SYMBOL.equalsIgnoreCase(symbol)) {
            this.symbol = FALSE_SYMBOL;
        } else if (PropositionSymbol.isPropositionSymbol(symbol)) {
            this.symbol = symbol;
        } else {
            throw new IllegalArgumentException("Not a legal proposition symbol: " + symbol);
        }
    }

    public boolean isAlwaysTrue() {
        return TRUE_SYMBOL.equals(this.symbol);
    }

    public static boolean isAlwaysTrueSymbol(String symbol) {
        return TRUE_SYMBOL.equalsIgnoreCase(symbol);
    }

    public boolean isAlwaysFalse() {
        return FALSE_SYMBOL.equals(this.symbol);
    }

    public static boolean isAlwaysFalseSymbol(String symbol) {
        return FALSE_SYMBOL.equalsIgnoreCase(symbol);
    }

    public static boolean isPropositionSymbol(String symbol) {
        return SourceVersion.isIdentifier(symbol);
    }

    public static boolean isPropositionSymbolIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    public static boolean isPropositionSymbolIdentifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropositionSymbol sym = (PropositionSymbol)o;
        return this.symbol.equals(sym.symbol);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public String toString() {
        return this.getSymbol();
    }
}

