/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.parsing.ast;

import aima.core.util.Util;
import java.util.Set;

public enum Connective {
    NOT("~", 10),
    AND("&", 8),
    OR("|", 6),
    IMPLICATION("=>", 4),
    BICONDITIONAL("<=>", 2);

    private static final Set<Character> _connectiveLeadingChars;
    private static final Set<Character> _connectiveChars;
    private final String symbol;
    private final int precedence;

    public String getSymbol() {
        return this.symbol;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public String toString() {
        return this.getSymbol();
    }

    public static boolean isConnective(String symbol) {
        if (NOT.getSymbol().equals(symbol)) {
            return true;
        }
        if (AND.getSymbol().equals(symbol)) {
            return true;
        }
        if (OR.getSymbol().equals(symbol)) {
            return true;
        }
        if (IMPLICATION.getSymbol().equals(symbol)) {
            return true;
        }
        return BICONDITIONAL.getSymbol().equals(symbol);
    }

    public static Connective get(String symbol) {
        if (NOT.getSymbol().equals(symbol)) {
            return NOT;
        }
        if (AND.getSymbol().equals(symbol)) {
            return AND;
        }
        if (OR.getSymbol().equals(symbol)) {
            return OR;
        }
        if (IMPLICATION.getSymbol().equals(symbol)) {
            return IMPLICATION;
        }
        if (BICONDITIONAL.getSymbol().equals(symbol)) {
            return BICONDITIONAL;
        }
        throw new IllegalArgumentException("Not a valid symbol for a connective: " + symbol);
    }

    public static boolean isConnectiveIdentifierStart(char ch) {
        return _connectiveLeadingChars.contains(Character.valueOf(ch));
    }

    public static boolean isConnectiveIdentifierPart(char ch) {
        return _connectiveChars.contains(Character.valueOf(ch));
    }

    private Connective(String symbol, int precedence) {
        this.symbol = symbol;
        this.precedence = precedence;
    }

    static {
        _connectiveLeadingChars = Util.createSet(Character.valueOf('~'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('='), Character.valueOf('<'));
        _connectiveChars = Util.createSet(Character.valueOf('~'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('='), Character.valueOf('<'), Character.valueOf('>'));
    }
}

