/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.parsing.ast;

import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.Sentence;

public class ComplexSentence
extends Sentence {
    private Connective connective;
    private Sentence[] simplerSentences;
    private int cachedHashCode = -1;
    private String cachedConcreteSyntax = null;

    public ComplexSentence(Connective connective, Sentence ... sentences) {
        this.assertLegalArguments(connective, sentences);
        this.connective = connective;
        this.simplerSentences = new Sentence[sentences.length];
        for (int i = 0; i < sentences.length; ++i) {
            this.simplerSentences[i] = sentences[i];
        }
    }

    public ComplexSentence(Sentence sentenceL, Connective binaryConnective, Sentence sentenceR) {
        this(binaryConnective, sentenceL, sentenceR);
    }

    @Override
    public Connective getConnective() {
        return this.connective;
    }

    @Override
    public int getNumberSimplerSentences() {
        return this.simplerSentences.length;
    }

    @Override
    public Sentence getSimplerSentence(int offset) {
        return this.simplerSentences[offset];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        boolean result = false;
        ComplexSentence other = (ComplexSentence)o;
        if (other.hashCode() == this.hashCode() && other.getConnective().equals((Object)this.getConnective()) && other.getNumberSimplerSentences() == this.getNumberSimplerSentences()) {
            result = true;
            for (int i = 0; i < this.getNumberSimplerSentences(); ++i) {
                if (other.getSimplerSentence(i).equals(this.getSimplerSentence(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public int hashCode() {
        if (this.cachedHashCode == -1) {
            this.cachedHashCode = 17 * this.getConnective().hashCode();
            for (Sentence s : this.simplerSentences) {
                this.cachedHashCode = this.cachedHashCode * 37 + s.hashCode();
            }
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedConcreteSyntax == null) {
            if (this.isUnarySentence()) {
                this.cachedConcreteSyntax = (Object)((Object)this.getConnective()) + this.bracketSentenceIfNecessary(this.getConnective(), this.getSimplerSentence(0));
            } else if (this.isBinarySentence()) {
                this.cachedConcreteSyntax = this.bracketSentenceIfNecessary(this.getConnective(), this.getSimplerSentence(0)) + " " + (Object)((Object)this.getConnective()) + " " + this.bracketSentenceIfNecessary(this.getConnective(), this.getSimplerSentence(1));
            }
        }
        return this.cachedConcreteSyntax;
    }

    private void assertLegalArguments(Connective connective, Sentence ... sentences) {
        if (connective == null) {
            throw new IllegalArgumentException("Connective must be specified.");
        }
        if (sentences == null) {
            throw new IllegalArgumentException("> 0 simpler sentences must be specified.");
        }
        if (connective == Connective.NOT) {
            if (sentences.length != 1) {
                throw new IllegalArgumentException("A not (~) complex sentence only take 1 simpler sentence not " + sentences.length);
            }
        } else if (sentences.length != 2) {
            throw new IllegalArgumentException("Connective is binary (" + (Object)((Object)connective) + ") but only " + sentences.length + " simpler sentences provided");
        }
    }
}

