/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.parsing;

import aima.core.logic.common.Lexer;
import aima.core.logic.common.Parser;
import aima.core.logic.common.ParserException;
import aima.core.logic.common.Token;
import aima.core.logic.propositional.parsing.PLLexer;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.logic.propositional.parsing.ast.Sentence;
import java.util.ArrayList;
import java.util.List;

public class PLParser
extends Parser<Sentence> {
    private PLLexer lexer = new PLLexer();

    @Override
    public Lexer getLexer() {
        return this.lexer;
    }

    @Override
    protected Sentence parse() {
        Sentence result = null;
        ParseNode root = this.parseSentence(0);
        if (root != null && root.node instanceof Sentence) {
            result = (Sentence)root.node;
        }
        return result;
    }

    private ParseNode parseSentence(int level) {
        List<ParseNode> levelParseNodes = this.parseLevel(level);
        ParseNode result = null;
        levelParseNodes = this.groupSimplerSentencesByConnective(Connective.NOT, levelParseNodes);
        levelParseNodes = this.groupSimplerSentencesByConnective(Connective.AND, levelParseNodes);
        levelParseNodes = this.groupSimplerSentencesByConnective(Connective.OR, levelParseNodes);
        levelParseNodes = this.groupSimplerSentencesByConnective(Connective.IMPLICATION, levelParseNodes);
        if ((levelParseNodes = this.groupSimplerSentencesByConnective(Connective.BICONDITIONAL, levelParseNodes)).size() != 1 || !(levelParseNodes.get((int)0).node instanceof Sentence)) {
            throw new ParserException("Unable to correctly parse sentence: " + levelParseNodes, this.getTokens(levelParseNodes));
        }
        result = levelParseNodes.get(0);
        return result;
    }

    private List<ParseNode> groupSimplerSentencesByConnective(Connective connectiveToConstruct, List<ParseNode> parseNodes) {
        ParseNode parseNode;
        int i;
        ArrayList<ParseNode> newParseNodes = new ArrayList<ParseNode>();
        int numSentencesMade = 0;
        for (i = parseNodes.size() - 1; i >= 0; --i) {
            ComplexSentence newSentence;
            parseNode = parseNodes.get(i);
            if (!(parseNode.node instanceof Connective)) continue;
            Connective tokenConnective = (Connective)((Object)parseNode.node);
            if (tokenConnective == Connective.NOT) {
                if (i + 1 < parseNodes.size() && parseNodes.get((int)(i + 1)).node instanceof Sentence) {
                    if (tokenConnective != connectiveToConstruct) continue;
                    newSentence = new ComplexSentence(connectiveToConstruct, (Sentence)parseNodes.get((int)(i + 1)).node);
                    parseNodes.set(i, new ParseNode(newSentence, parseNode.token));
                    parseNodes.set(i + 1, null);
                    ++numSentencesMade;
                    continue;
                }
                throw new ParserException("Unary connective argurment is not a sentence at input position " + parseNode.token.getStartCharPositionInInput(), parseNode.token);
            }
            if (i - 1 >= 0 && parseNodes.get((int)(i - 1)).node instanceof Sentence && i + 1 < parseNodes.size() && parseNodes.get((int)(i + 1)).node instanceof Sentence) {
                if (tokenConnective != connectiveToConstruct) continue;
                newSentence = new ComplexSentence(connectiveToConstruct, (Sentence)parseNodes.get((int)(i - 1)).node, (Sentence)parseNodes.get((int)(i + 1)).node);
                parseNodes.set(i - 1, new ParseNode(newSentence, parseNode.token));
                parseNodes.set(i, null);
                parseNodes.set(i + 1, null);
                ++numSentencesMade;
                continue;
            }
            throw new ParserException("Binary connective argurments are not sentences at input position " + parseNode.token.getStartCharPositionInInput(), parseNode.token);
        }
        for (i = 0; i < parseNodes.size(); ++i) {
            parseNode = parseNodes.get(i);
            if (parseNode == null) continue;
            newParseNodes.add(parseNode);
        }
        int toSubtract = 0;
        toSubtract = connectiveToConstruct == Connective.NOT ? numSentencesMade * 2 - numSentencesMade : numSentencesMade * 3 - numSentencesMade;
        if (parseNodes.size() - toSubtract != newParseNodes.size()) {
            throw new ParserException("Unable to construct sentence for connective: " + (Object)((Object)connectiveToConstruct) + " from: " + parseNodes, this.getTokens(parseNodes));
        }
        return newParseNodes;
    }

    private List<ParseNode> parseLevel(int level) {
        ArrayList<ParseNode> tokens = new ArrayList<ParseNode>();
        while (this.lookAhead(1).getType() != 9999 && this.lookAhead(1).getType() != 3 && this.lookAhead(1).getType() != 5) {
            if (this.detectConnective()) {
                tokens.add(this.parseConnective());
                continue;
            }
            if (this.detectAtomicSentence()) {
                tokens.add(this.parseAtomicSentence());
                continue;
            }
            if (!this.detectBracket()) continue;
            tokens.add(this.parseBracketedSentence(level));
        }
        if (level > 0 && this.lookAhead(1).getType() == 9999) {
            throw new ParserException("Parser Error: end of input not expected at level " + level, this.lookAhead(1));
        }
        return tokens;
    }

    private boolean detectConnective() {
        return this.lookAhead(1).getType() == 7;
    }

    private ParseNode parseConnective() {
        Token token = this.lookAhead(1);
        Connective connective = Connective.get(token.getText());
        this.consume();
        return new ParseNode((Object)connective, token);
    }

    private boolean detectAtomicSentence() {
        int type = this.lookAhead(1).getType();
        return type == 13 || type == 14 || type == 1;
    }

    private ParseNode parseAtomicSentence() {
        Token t = this.lookAhead(1);
        if (t.getType() == 13) {
            return this.parseTrue();
        }
        if (t.getType() == 14) {
            return this.parseFalse();
        }
        if (t.getType() == 1) {
            return this.parseSymbol();
        }
        throw new ParserException("Error parsing atomic sentence at position " + t.getStartCharPositionInInput(), t);
    }

    private ParseNode parseTrue() {
        Token token = this.lookAhead(1);
        this.consume();
        return new ParseNode(new PropositionSymbol("True"), token);
    }

    private ParseNode parseFalse() {
        Token token = this.lookAhead(1);
        this.consume();
        return new ParseNode(new PropositionSymbol("False"), token);
    }

    private ParseNode parseSymbol() {
        Token token = this.lookAhead(1);
        String sym = token.getText();
        this.consume();
        return new ParseNode(new PropositionSymbol(sym), token);
    }

    private boolean detectBracket() {
        return this.lookAhead(1).getType() == 2 || this.lookAhead(1).getType() == 4;
    }

    private ParseNode parseBracketedSentence(int level) {
        Token startToken = this.lookAhead(1);
        String start = "(";
        String end = ")";
        if (startToken.getType() == 4) {
            start = "[";
            end = "]";
        }
        this.match(start);
        ParseNode bracketedSentence = this.parseSentence(level + 1);
        this.match(end);
        return bracketedSentence;
    }

    private Token[] getTokens(List<ParseNode> parseNodes) {
        Token[] result = new Token[parseNodes.size()];
        for (int i = 0; i < parseNodes.size(); ++i) {
            result[i] = parseNodes.get((int)i).token;
        }
        return result;
    }

    private class ParseNode {
        public Object node = null;
        public Token token = null;

        public ParseNode(Object node, Token token) {
            this.node = node;
            this.token = token;
        }

        public String toString() {
            return this.node.toString() + " at " + this.token.getStartCharPositionInInput();
        }
    }
}

