/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.parsing;

import aima.core.logic.common.Lexer;
import aima.core.logic.common.LexerException;
import aima.core.logic.common.Token;
import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;

public class PLLexer
extends Lexer {
    public PLLexer() {
    }

    public PLLexer(String inputString) {
        this.setInput(inputString);
    }

    @Override
    public Token nextToken() {
        int startPosition = this.getCurrentPositionInInput();
        if (this.lookAhead(1) == '(') {
            this.consume();
            return new Token(2, "(", startPosition);
        }
        if (this.lookAhead(1) == '[') {
            this.consume();
            return new Token(4, "[", startPosition);
        }
        if (this.lookAhead(1) == ')') {
            this.consume();
            return new Token(3, ")", startPosition);
        }
        if (this.lookAhead(1) == ']') {
            this.consume();
            return new Token(5, "]", startPosition);
        }
        if (Character.isWhitespace(this.lookAhead(1))) {
            this.consume();
            return this.nextToken();
        }
        if (this.connectiveDetected(this.lookAhead(1))) {
            return this.connective();
        }
        if (this.symbolDetected(this.lookAhead(1))) {
            return this.symbol();
        }
        if (this.lookAhead(1) == '\uffff') {
            return new Token(9999, "EOI", startPosition);
        }
        throw new LexerException("Lexing error on character " + this.lookAhead(1) + " at position " + this.getCurrentPositionInInput(), this.getCurrentPositionInInput());
    }

    private boolean connectiveDetected(char leadingChar) {
        return Connective.isConnectiveIdentifierStart(leadingChar);
    }

    private boolean symbolDetected(char leadingChar) {
        return PropositionSymbol.isPropositionSymbolIdentifierStart(leadingChar);
    }

    private Token connective() {
        int startPosition = this.getCurrentPositionInInput();
        StringBuffer sbuf = new StringBuffer();
        while (Connective.isConnectiveIdentifierPart(this.lookAhead(1)) && !this.isConnective(sbuf.toString())) {
            sbuf.append(this.lookAhead(1));
            this.consume();
        }
        String symbol = sbuf.toString();
        if (this.isConnective(symbol)) {
            return new Token(7, sbuf.toString(), startPosition);
        }
        throw new LexerException("Lexing error on connective " + symbol + " at position " + this.getCurrentPositionInInput(), this.getCurrentPositionInInput());
    }

    private Token symbol() {
        int startPosition = this.getCurrentPositionInInput();
        StringBuffer sbuf = new StringBuffer();
        while (PropositionSymbol.isPropositionSymbolIdentifierPart(this.lookAhead(1))) {
            sbuf.append(this.lookAhead(1));
            this.consume();
        }
        String symbol = sbuf.toString();
        if (PropositionSymbol.isAlwaysTrueSymbol(symbol)) {
            return new Token(13, "True", startPosition);
        }
        if (PropositionSymbol.isAlwaysFalseSymbol(symbol)) {
            return new Token(14, "False", startPosition);
        }
        if (PropositionSymbol.isPropositionSymbol(symbol)) {
            return new Token(1, sbuf.toString(), startPosition);
        }
        throw new LexerException("Lexing error on symbol " + symbol + " at position " + this.getCurrentPositionInInput(), this.getCurrentPositionInInput());
    }

    private boolean isConnective(String aSymbol) {
        return Connective.isConnective(aSymbol);
    }
}

