/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.kb.data;

import aima.core.logic.propositional.kb.data.Clause;
import aima.core.logic.propositional.parsing.PLVisitor;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.logic.propositional.parsing.ast.Sentence;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Model
implements PLVisitor<Boolean, Boolean> {
    private HashMap<PropositionSymbol, Boolean> assignments = new HashMap();

    public Model() {
    }

    public Model(Map<PropositionSymbol, Boolean> values) {
        this.assignments.putAll(values);
    }

    public Boolean getValue(PropositionSymbol symbol) {
        return this.assignments.get(symbol);
    }

    public boolean isTrue(PropositionSymbol symbol) {
        return Boolean.TRUE.equals(this.assignments.get(symbol));
    }

    public boolean isFalse(PropositionSymbol symbol) {
        return Boolean.FALSE.equals(this.assignments.get(symbol));
    }

    public Model union(PropositionSymbol symbol, boolean b) {
        Model m = new Model();
        m.assignments.putAll(this.assignments);
        m.assignments.put(symbol, b);
        return m;
    }

    public Model unionInPlace(PropositionSymbol symbol, boolean b) {
        this.assignments.put(symbol, b);
        return this;
    }

    public boolean remove(PropositionSymbol p) {
        return this.assignments.remove(p);
    }

    public boolean isTrue(Sentence s) {
        return Boolean.TRUE.equals(s.accept(this, null));
    }

    public boolean isFalse(Sentence s) {
        return Boolean.FALSE.equals(s.accept(this, null));
    }

    public boolean isUnknown(Sentence s) {
        return null == s.accept(this, null);
    }

    public Model flip(PropositionSymbol s) {
        if (this.isTrue(s)) {
            return this.union(s, false);
        }
        if (this.isFalse(s)) {
            return this.union(s, true);
        }
        return this;
    }

    public Set<PropositionSymbol> getAssignedSymbols() {
        return Collections.unmodifiableSet(this.assignments.keySet());
    }

    public boolean satisfies(Set<Clause> clauses) {
        for (Clause c : clauses) {
            if (Boolean.TRUE.equals(this.determineValue(c))) continue;
            return false;
        }
        return true;
    }

    public Boolean determineValue(Clause c) {
        Boolean result = null;
        if (c.isTautology()) {
            result = Boolean.TRUE;
        } else if (c.isFalse()) {
            result = Boolean.FALSE;
        } else {
            boolean unassignedSymbols = false;
            Boolean value = null;
            for (PropositionSymbol positive : c.getPositiveSymbols()) {
                value = this.assignments.get(positive);
                if (value != null) {
                    if (!Boolean.TRUE.equals(value)) continue;
                    result = Boolean.TRUE;
                    break;
                }
                unassignedSymbols = true;
            }
            if (result == null) {
                for (PropositionSymbol negative : c.getNegativeSymbols()) {
                    value = this.assignments.get(negative);
                    if (value != null) {
                        if (!Boolean.FALSE.equals(value)) continue;
                        result = Boolean.TRUE;
                        break;
                    }
                    unassignedSymbols = true;
                }
                if (result == null && !unassignedSymbols) {
                    result = Boolean.FALSE;
                }
            }
        }
        return result;
    }

    public void print() {
        for (Map.Entry<PropositionSymbol, Boolean> e : this.assignments.entrySet()) {
            System.out.print(e.getKey() + " = " + e.getValue() + " ");
        }
        System.out.println();
    }

    public String toString() {
        return this.assignments.toString();
    }

    @Override
    public Boolean visitPropositionSymbol(PropositionSymbol s, Boolean arg) {
        if (s.isAlwaysTrue()) {
            return Boolean.TRUE;
        }
        if (s.isAlwaysFalse()) {
            return Boolean.FALSE;
        }
        return this.getValue(s);
    }

    @Override
    public Boolean visitUnarySentence(ComplexSentence fs, Boolean arg) {
        Boolean negatedValue = fs.getSimplerSentence(0).accept(this, null);
        if (negatedValue != null) {
            return new Boolean(negatedValue == false);
        }
        return null;
    }

    @Override
    public Boolean visitBinarySentence(ComplexSentence bs, Boolean arg) {
        Boolean firstValue = bs.getSimplerSentence(0).accept(this, null);
        Boolean secondValue = bs.getSimplerSentence(1).accept(this, null);
        if (firstValue == null || secondValue == null) {
            return null;
        }
        Connective connective = bs.getConnective();
        if (connective.equals((Object)Connective.AND)) {
            return firstValue != false && secondValue != false;
        }
        if (connective.equals((Object)Connective.OR)) {
            return firstValue != false || secondValue != false;
        }
        if (connective.equals((Object)Connective.IMPLICATION)) {
            return firstValue == false || secondValue != false;
        }
        if (connective.equals((Object)Connective.BICONDITIONAL)) {
            return firstValue.equals(secondValue);
        }
        return null;
    }
}

