/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.kb.data;

import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;

public class Literal {
    private PropositionSymbol atom = null;
    private boolean positive = true;
    private String cachedStringRep = null;
    private int cachedHashCode = -1;

    public Literal(PropositionSymbol atom) {
        this(atom, true);
    }

    public Literal(PropositionSymbol atom, boolean positive) {
        this.atom = atom;
        this.positive = positive;
    }

    public boolean isPositiveLiteral() {
        return this.positive;
    }

    public boolean isNegativeLiteral() {
        return !this.positive;
    }

    public PropositionSymbol getAtomicSentence() {
        return this.atom;
    }

    public boolean isAlwaysTrue() {
        if (this.isPositiveLiteral()) {
            return this.getAtomicSentence().isAlwaysTrue();
        }
        return this.getAtomicSentence().isAlwaysFalse();
    }

    public boolean isAlwaysFalse() {
        if (this.isPositiveLiteral()) {
            return this.getAtomicSentence().isAlwaysFalse();
        }
        return this.getAtomicSentence().isAlwaysTrue();
    }

    public String toString() {
        if (null == this.cachedStringRep) {
            StringBuilder sb = new StringBuilder();
            if (this.isNegativeLiteral()) {
                sb.append(Connective.NOT.toString());
            }
            sb.append(this.getAtomicSentence().toString());
            this.cachedStringRep = sb.toString();
        }
        return this.cachedStringRep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Literal)) {
            return false;
        }
        Literal l = (Literal)o;
        return l.isPositiveLiteral() == this.isPositiveLiteral() && l.getAtomicSentence().equals(this.getAtomicSentence());
    }

    public int hashCode() {
        if (this.cachedHashCode == -1) {
            this.cachedHashCode = 17;
            this.cachedHashCode = this.cachedHashCode * 37 + (this.isPositiveLiteral() ? "+".hashCode() : "-".hashCode());
            this.cachedHashCode = this.cachedHashCode * 37 + this.atom.hashCode();
        }
        return this.cachedHashCode;
    }
}

