/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.kb.data;

import aima.core.logic.propositional.kb.data.Clause;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ConjunctionOfClauses {
    private Set<Clause> clauses = new LinkedHashSet<Clause>();
    private String cachedStringRep = null;
    private int cachedHashCode = -1;

    public ConjunctionOfClauses(Collection<Clause> conjunctionOfClauses) {
        this.clauses.addAll(conjunctionOfClauses);
        this.clauses = Collections.unmodifiableSet(this.clauses);
    }

    public int getNumberOfClauses() {
        return this.clauses.size();
    }

    public Set<Clause> getClauses() {
        return this.clauses;
    }

    public ConjunctionOfClauses extend(Collection<Clause> additionalClauses) {
        LinkedHashSet<Clause> extendedClauses = new LinkedHashSet<Clause>();
        extendedClauses.addAll(this.clauses);
        extendedClauses.addAll(additionalClauses);
        ConjunctionOfClauses result = new ConjunctionOfClauses(extendedClauses);
        return result;
    }

    public String toString() {
        if (this.cachedStringRep == null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            sb.append("{");
            for (Clause c : this.clauses) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(c);
            }
            sb.append("}");
            this.cachedStringRep = sb.toString();
        }
        return this.cachedStringRep;
    }

    public int hashCode() {
        if (this.cachedHashCode == -1) {
            this.cachedHashCode = this.clauses.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object othObj) {
        if (null == othObj) {
            return false;
        }
        if (this == othObj) {
            return true;
        }
        if (!(othObj instanceof ConjunctionOfClauses)) {
            return false;
        }
        ConjunctionOfClauses othConjunctionOfClauses = (ConjunctionOfClauses)othObj;
        return othConjunctionOfClauses.clauses.equals(this.clauses);
    }
}

