/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.kb.data;

import aima.core.logic.propositional.kb.data.Literal;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.util.SetOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class Clause {
    public static final Clause EMPTY = new Clause();
    private Set<Literal> literals = new LinkedHashSet<Literal>();
    private Set<PropositionSymbol> cachedPositiveSymbols = new LinkedHashSet<PropositionSymbol>();
    private Set<PropositionSymbol> cachedNegativeSymbols = new LinkedHashSet<PropositionSymbol>();
    private Set<PropositionSymbol> cachedSymbols = new LinkedHashSet<PropositionSymbol>();
    private Boolean cachedIsTautologyResult = null;
    private String cachedStringRep = null;
    private int cachedHashCode = -1;

    public Clause() {
        this(new ArrayList<Literal>());
    }

    public Clause(Literal ... literals) {
        this(Arrays.asList(literals));
    }

    public Clause(Collection<Literal> literals) {
        for (Literal l : literals) {
            if (l.isAlwaysFalse() || !this.literals.add(l)) continue;
            if (l.isPositiveLiteral()) {
                this.cachedPositiveSymbols.add(l.getAtomicSentence());
                continue;
            }
            this.cachedNegativeSymbols.add(l.getAtomicSentence());
        }
        this.cachedSymbols.addAll(this.cachedPositiveSymbols);
        this.cachedSymbols.addAll(this.cachedNegativeSymbols);
        this.literals = Collections.unmodifiableSet(this.literals);
        this.cachedSymbols = Collections.unmodifiableSet(this.cachedSymbols);
        this.cachedPositiveSymbols = Collections.unmodifiableSet(this.cachedPositiveSymbols);
        this.cachedNegativeSymbols = Collections.unmodifiableSet(this.cachedNegativeSymbols);
    }

    public boolean isFalse() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.literals.size() == 0;
    }

    public boolean isUnitClause() {
        return this.literals.size() == 1;
    }

    public boolean isDefiniteClause() {
        return this.cachedPositiveSymbols.size() == 1;
    }

    public boolean isImplicationDefiniteClause() {
        return this.isDefiniteClause() && this.cachedNegativeSymbols.size() >= 1;
    }

    public boolean isHornClause() {
        return !this.isEmpty() && this.cachedPositiveSymbols.size() <= 1;
    }

    public boolean isGoalClause() {
        return !this.isEmpty() && this.cachedPositiveSymbols.size() == 0;
    }

    public boolean isTautology() {
        if (this.cachedIsTautologyResult == null) {
            for (Literal l : this.literals) {
                if (!l.isAlwaysTrue()) continue;
                this.cachedIsTautologyResult = true;
            }
            if (this.cachedIsTautologyResult == null) {
                this.cachedIsTautologyResult = SetOps.intersection(this.cachedPositiveSymbols, this.cachedNegativeSymbols).size() > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
        }
        return this.cachedIsTautologyResult;
    }

    public int getNumberLiterals() {
        return this.literals.size();
    }

    public int getNumberPositiveLiterals() {
        return this.cachedPositiveSymbols.size();
    }

    public int getNumberNegativeLiterals() {
        return this.cachedNegativeSymbols.size();
    }

    public Set<Literal> getLiterals() {
        return this.literals;
    }

    public Set<PropositionSymbol> getSymbols() {
        return this.cachedSymbols;
    }

    public Set<PropositionSymbol> getPositiveSymbols() {
        return this.cachedPositiveSymbols;
    }

    public Set<PropositionSymbol> getNegativeSymbols() {
        return this.cachedNegativeSymbols;
    }

    public String toString() {
        if (this.cachedStringRep == null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            sb.append("{");
            for (Literal l : this.literals) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(l);
            }
            sb.append("}");
            this.cachedStringRep = sb.toString();
        }
        return this.cachedStringRep;
    }

    public boolean equals(Object othObj) {
        if (null == othObj) {
            return false;
        }
        if (this == othObj) {
            return true;
        }
        if (!(othObj instanceof Clause)) {
            return false;
        }
        Clause othClause = (Clause)othObj;
        return othClause.literals.equals(this.literals);
    }

    public int hashCode() {
        if (this.cachedHashCode == -1) {
            this.cachedHashCode = this.literals.hashCode();
        }
        return this.cachedHashCode;
    }
}

