/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.kb;

import aima.core.logic.propositional.inference.TTEntails;
import aima.core.logic.propositional.kb.data.Clause;
import aima.core.logic.propositional.kb.data.ConjunctionOfClauses;
import aima.core.logic.propositional.parsing.PLParser;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.logic.propositional.parsing.ast.Sentence;
import aima.core.logic.propositional.visitors.ConvertToConjunctionOfClauses;
import aima.core.logic.propositional.visitors.SymbolCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class KnowledgeBase {
    private List<Sentence> sentences = new ArrayList<Sentence>();
    private ConjunctionOfClauses asCNF = new ConjunctionOfClauses(Collections.emptySet());
    private Set<PropositionSymbol> symbols = new LinkedHashSet<PropositionSymbol>();
    private PLParser parser = new PLParser();

    public void tell(String aSentence) {
        this.tell((Sentence)this.parser.parse(aSentence));
    }

    public void tell(Sentence aSentence) {
        if (!this.sentences.contains(aSentence)) {
            this.sentences.add(aSentence);
            this.asCNF = this.asCNF.extend(ConvertToConjunctionOfClauses.convert(aSentence).getClauses());
            this.symbols.addAll(SymbolCollector.getSymbolsFrom(aSentence));
        }
    }

    public void tellAll(String[] percepts) {
        for (int i = 0; i < percepts.length; ++i) {
            this.tell(percepts[i]);
        }
    }

    public int size() {
        return this.sentences.size();
    }

    public Sentence asSentence() {
        return Sentence.newConjunction(this.sentences);
    }

    public Set<Clause> asCNF() {
        return this.asCNF.getClauses();
    }

    public Set<PropositionSymbol> getSymbols() {
        return this.symbols;
    }

    public boolean askWithTTEntails(String queryString) {
        PLParser parser = new PLParser();
        Sentence alpha = (Sentence)parser.parse(queryString);
        return new TTEntails().ttEntails(this, alpha);
    }

    public String toString() {
        if (this.sentences.size() == 0) {
            return "";
        }
        return this.asSentence().toString();
    }

    public List<Sentence> getSentences() {
        return this.sentences;
    }
}

