/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.inference;

import aima.core.logic.propositional.kb.data.Clause;
import aima.core.logic.propositional.kb.data.Model;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;

public class WalkSAT {
    private Random random = new Random();

    public Model walkSAT(Set<Clause> clauses, double p, int maxFlips) {
        this.assertLegalProbability(p);
        Model model = this.randomAssignmentToSymbolsInClauses(clauses);
        for (int i = 0; i < maxFlips || maxFlips < 0; ++i) {
            if (model.satisfies(clauses)) {
                return model;
            }
            Clause clause = this.randomlySelectFalseClause(clauses, model);
            model = this.random.nextDouble() < p ? model.flip(this.randomlySelectSymbolFromClause(clause)) : this.flipSymbolInClauseMaximizesNumberSatisfiedClauses(clause, clauses, model);
        }
        return null;
    }

    public WalkSAT() {
    }

    public WalkSAT(Random random) {
        this.random = random;
    }

    protected void assertLegalProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p is not a legal propbability value [0-1]: " + p);
        }
    }

    protected Model randomAssignmentToSymbolsInClauses(Set<Clause> clauses) {
        LinkedHashSet<PropositionSymbol> symbols = new LinkedHashSet<PropositionSymbol>();
        for (Clause clause : clauses) {
            symbols.addAll(clause.getSymbols());
        }
        HashMap<PropositionSymbol, Boolean> values = new HashMap<PropositionSymbol, Boolean>();
        for (PropositionSymbol symbol : symbols) {
            values.put(symbol, this.random.nextBoolean());
        }
        Model model = new Model(values);
        return model;
    }

    protected Clause randomlySelectFalseClause(Set<Clause> clauses, Model model) {
        ArrayList<Clause> falseClauses = new ArrayList<Clause>();
        for (Clause c : clauses) {
            if (!Boolean.FALSE.equals(model.determineValue(c))) continue;
            falseClauses.add(c);
        }
        Clause result = (Clause)falseClauses.get(this.random.nextInt(falseClauses.size()));
        return result;
    }

    protected PropositionSymbol randomlySelectSymbolFromClause(Clause clause) {
        Set<PropositionSymbol> symbols = clause.getSymbols();
        PropositionSymbol result = new ArrayList<PropositionSymbol>(symbols).get(this.random.nextInt(symbols.size()));
        return result;
    }

    protected Model flipSymbolInClauseMaximizesNumberSatisfiedClauses(Clause clause, Set<Clause> clauses, Model model) {
        Model result = model;
        Set<PropositionSymbol> symbols = clause.getSymbols();
        int maxClausesSatisfied = -1;
        for (PropositionSymbol symbol : symbols) {
            Model flippedModel = result.flip(symbol);
            int numberClausesSatisfied = 0;
            for (Clause c : clauses) {
                if (!Boolean.TRUE.equals(flippedModel.determineValue(c))) continue;
                ++numberClausesSatisfied;
            }
            if (numberClausesSatisfied <= maxClausesSatisfied) continue;
            result = flippedModel;
            maxClausesSatisfied = numberClausesSatisfied;
            if (numberClausesSatisfied != clauses.size()) continue;
            break;
        }
        return result;
    }
}

