/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.inference;

import aima.core.agent.Action;
import aima.core.logic.propositional.inference.SATSolver;
import aima.core.logic.propositional.kb.data.Clause;
import aima.core.logic.propositional.kb.data.Model;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.Sentence;
import aima.core.logic.propositional.visitors.ConvertToConjunctionOfClauses;
import java.util.List;
import java.util.Set;

public class SATPlan {
    private SATSolver satSolver = null;
    private SolutionExtractor solutionExtractor = null;

    public List<Action> satPlan(Describe init, Describe transition, Describe goal, int tMax) {
        for (int t = 0; t <= tMax; ++t) {
            Set<Clause> cnf = this.translateToSAT(init, transition, goal, t);
            Model model = this.satSolver.solve(cnf);
            if (model == null) continue;
            return this.solutionExtractor.extractSolution(model);
        }
        return null;
    }

    public SATPlan(SATSolver satSolver, SolutionExtractor solutionExtractor) {
        this.satSolver = satSolver;
        this.solutionExtractor = solutionExtractor;
    }

    protected Set<Clause> translateToSAT(Describe init, Describe transition, Describe goal, int t) {
        Sentence s = ComplexSentence.newConjunction(init.assertions(t), transition.assertions(t), goal.assertions(t));
        return ConvertToConjunctionOfClauses.convert(s).getClauses();
    }

    static interface SolutionExtractor {
        public List<Action> extractSolution(Model var1);
    }

    static interface Describe {
        public Sentence assertions(int var1);
    }
}

