/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.inference;

import aima.core.logic.propositional.kb.KnowledgeBase;
import aima.core.logic.propositional.kb.data.Clause;
import aima.core.logic.propositional.kb.data.Literal;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.logic.propositional.parsing.ast.Sentence;
import aima.core.logic.propositional.visitors.ConvertToConjunctionOfClauses;
import aima.core.util.SetOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class PLResolution {
    private boolean discardTautologies = true;

    public boolean plResolution(KnowledgeBase kb, Sentence alpha) {
        Set<Clause> clauses = this.setOfClausesInTheCNFRepresentationOfKBAndNotAlpha(kb, alpha);
        LinkedHashSet<Clause> newClauses = new LinkedHashSet<Clause>();
        while (true) {
            ArrayList<Clause> clausesAsList = new ArrayList<Clause>(clauses);
            for (int i = 0; i < clausesAsList.size() - 1; ++i) {
                Clause ci = (Clause)clausesAsList.get(i);
                for (int j = i + 1; j < clausesAsList.size(); ++j) {
                    Clause cj = (Clause)clausesAsList.get(j);
                    Set<Clause> resolvents = this.plResolve(ci, cj);
                    if (resolvents.contains(Clause.EMPTY)) {
                        return true;
                    }
                    newClauses.addAll(resolvents);
                }
            }
            if (clauses.containsAll(newClauses)) {
                return false;
            }
            clauses.addAll(newClauses);
        }
    }

    public Set<Clause> plResolve(Clause ci, Clause cj) {
        LinkedHashSet<Clause> resolvents = new LinkedHashSet<Clause>();
        this.resolvePositiveWithNegative(ci, cj, resolvents);
        this.resolvePositiveWithNegative(cj, ci, resolvents);
        return resolvents;
    }

    public PLResolution() {
        this(true);
    }

    public PLResolution(boolean discardTautologies) {
        this.setDiscardTautologies(discardTautologies);
    }

    public boolean isDiscardTautologies() {
        return this.discardTautologies;
    }

    public void setDiscardTautologies(boolean discardTautologies) {
        this.discardTautologies = discardTautologies;
    }

    protected Set<Clause> setOfClausesInTheCNFRepresentationOfKBAndNotAlpha(KnowledgeBase kb, Sentence alpha) {
        ComplexSentence isContradiction = new ComplexSentence(Connective.AND, kb.asSentence(), new ComplexSentence(Connective.NOT, alpha));
        LinkedHashSet<Clause> clauses = new LinkedHashSet<Clause>(ConvertToConjunctionOfClauses.convert(isContradiction).getClauses());
        this.discardTautologies(clauses);
        return clauses;
    }

    protected void resolvePositiveWithNegative(Clause c1, Clause c2, Set<Clause> resolvents) {
        Set<PropositionSymbol> complementary = SetOps.intersection(c1.getPositiveSymbols(), c2.getNegativeSymbols());
        for (PropositionSymbol complement : complementary) {
            ArrayList<Literal> resolventLiterals = new ArrayList<Literal>();
            for (Literal c1l : c1.getLiterals()) {
                if (!c1l.isNegativeLiteral() && c1l.getAtomicSentence().equals(complement)) continue;
                resolventLiterals.add(c1l);
            }
            for (Literal c2l : c2.getLiterals()) {
                if (!c2l.isPositiveLiteral() && c2l.getAtomicSentence().equals(complement)) continue;
                resolventLiterals.add(c2l);
            }
            Clause resolvent = new Clause(resolventLiterals);
            if (this.isDiscardTautologies() && resolvent.isTautology()) continue;
            resolvents.add(resolvent);
        }
    }

    protected void discardTautologies(Set<Clause> clauses) {
        if (this.isDiscardTautologies()) {
            HashSet<Clause> toDiscard = new HashSet<Clause>();
            for (Clause c : clauses) {
                if (!c.isTautology()) continue;
                toDiscard.add(c);
            }
            clauses.removeAll(toDiscard);
        }
    }
}

