/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.inference;

import aima.core.logic.propositional.kb.KnowledgeBase;
import aima.core.logic.propositional.kb.data.Clause;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.logic.propositional.visitors.ConvertToConjunctionOfClauses;
import aima.core.logic.propositional.visitors.SymbolCollector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class PLFCEntails {
    public boolean plfcEntails(KnowledgeBase kb, PropositionSymbol q) {
        Map<Clause, Integer> count = this.initializeCount(kb);
        Map<PropositionSymbol, Boolean> inferred = this.initializeInferred(kb);
        Queue<PropositionSymbol> agenda = this.initializeAgenda(count);
        Map<PropositionSymbol, Set<Clause>> pToClausesWithPInPremise = this.initializeIndex(count, inferred);
        while (!agenda.isEmpty()) {
            PropositionSymbol p = agenda.remove();
            if (p.equals(q)) {
                return true;
            }
            if (!inferred.get(p).equals(Boolean.FALSE)) continue;
            inferred.put(p, true);
            for (Clause c : pToClausesWithPInPremise.get(p)) {
                this.decrement(count, c);
                if (count.get(c) != 0) continue;
                agenda.add(this.conclusion(c));
            }
        }
        return false;
    }

    protected Map<Clause, Integer> initializeCount(KnowledgeBase kb) {
        HashMap<Clause, Integer> count = new HashMap<Clause, Integer>();
        Set<Clause> clauses = ConvertToConjunctionOfClauses.convert(kb.asSentence()).getClauses();
        for (Clause c : clauses) {
            if (!c.isDefiniteClause()) {
                throw new IllegalArgumentException("Knowledge Base contains non-definite clauses:" + c);
            }
            count.put(c, c.getNumberNegativeLiterals());
        }
        return count;
    }

    protected Map<PropositionSymbol, Boolean> initializeInferred(KnowledgeBase kb) {
        HashMap<PropositionSymbol, Boolean> inferred = new HashMap<PropositionSymbol, Boolean>();
        for (PropositionSymbol p : SymbolCollector.getSymbolsFrom(kb.asSentence())) {
            inferred.put(p, false);
        }
        return inferred;
    }

    protected Queue<PropositionSymbol> initializeAgenda(Map<Clause, Integer> count) {
        LinkedList<PropositionSymbol> agenda = new LinkedList<PropositionSymbol>();
        for (Clause c : count.keySet()) {
            if (c.getNumberNegativeLiterals() != 0) continue;
            agenda.add(this.conclusion(c));
        }
        return agenda;
    }

    protected Map<PropositionSymbol, Set<Clause>> initializeIndex(Map<Clause, Integer> count, Map<PropositionSymbol, Boolean> inferred) {
        HashMap<PropositionSymbol, Set<Clause>> pToClausesWithPInPremise = new HashMap<PropositionSymbol, Set<Clause>>();
        for (PropositionSymbol p : inferred.keySet()) {
            HashSet<Clause> clausesWithPInPremise = new HashSet<Clause>();
            for (Clause c : count.keySet()) {
                if (!c.getNegativeSymbols().contains(p)) continue;
                clausesWithPInPremise.add(c);
            }
            pToClausesWithPInPremise.put(p, clausesWithPInPremise);
        }
        return pToClausesWithPInPremise;
    }

    protected void decrement(Map<Clause, Integer> count, Clause c) {
        int currentCount = count.get(c);
        count.put(c, currentCount - 1);
    }

    protected PropositionSymbol conclusion(Clause c) {
        return c.getPositiveSymbols().iterator().next();
    }
}

