/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.propositional.inference;

import aima.core.logic.propositional.inference.DPLL;
import aima.core.logic.propositional.kb.KnowledgeBase;
import aima.core.logic.propositional.kb.data.Clause;
import aima.core.logic.propositional.kb.data.Literal;
import aima.core.logic.propositional.kb.data.Model;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.logic.propositional.parsing.ast.Sentence;
import aima.core.logic.propositional.visitors.ConvertToConjunctionOfClauses;
import aima.core.logic.propositional.visitors.SymbolCollector;
import aima.core.util.Util;
import aima.core.util.datastructure.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DPLLSatisfiable
implements DPLL {
    @Override
    public boolean dpllSatisfiable(Sentence s) {
        Set<Clause> clauses = ConvertToConjunctionOfClauses.convert(s).getClauses();
        List<PropositionSymbol> symbols = this.getPropositionSymbolsInSentence(s);
        return this.dpll(clauses, symbols, new Model());
    }

    @Override
    public boolean dpll(Set<Clause> clauses, List<PropositionSymbol> symbols, Model model) {
        if (this.everyClauseTrue(clauses, model)) {
            return true;
        }
        if (this.someClauseFalse(clauses, model)) {
            return false;
        }
        Pair<PropositionSymbol, Boolean> pAndValue = this.findPureSymbol(symbols, clauses, model);
        if (pAndValue != null) {
            return this.dpll(clauses, this.minus(symbols, pAndValue.getFirst()), model.union(pAndValue.getFirst(), pAndValue.getSecond()));
        }
        pAndValue = this.findUnitClause(clauses, model);
        if (pAndValue != null) {
            return this.dpll(clauses, this.minus(symbols, pAndValue.getFirst()), model.union(pAndValue.getFirst(), pAndValue.getSecond()));
        }
        PropositionSymbol p = Util.first(symbols);
        List<PropositionSymbol> rest = Util.rest(symbols);
        return this.dpll(clauses, rest, model.union(p, true)) || this.dpll(clauses, rest, model.union(p, false));
    }

    @Override
    public boolean isEntailed(KnowledgeBase kb, Sentence alpha) {
        LinkedHashSet<Clause> kbAndNotAlpha = new LinkedHashSet<Clause>();
        ComplexSentence notQuery = new ComplexSentence(Connective.NOT, alpha);
        LinkedHashSet<PropositionSymbol> symbols = new LinkedHashSet<PropositionSymbol>();
        ArrayList<PropositionSymbol> querySymbols = new ArrayList<PropositionSymbol>(SymbolCollector.getSymbolsFrom(notQuery));
        kbAndNotAlpha.addAll(kb.asCNF());
        kbAndNotAlpha.addAll(ConvertToConjunctionOfClauses.convert(notQuery).getClauses());
        symbols.addAll(querySymbols);
        symbols.addAll(kb.getSymbols());
        return !this.dpll(kbAndNotAlpha, new ArrayList<PropositionSymbol>(symbols), new Model());
    }

    protected List<PropositionSymbol> getPropositionSymbolsInSentence(Sentence s) {
        ArrayList<PropositionSymbol> result = new ArrayList<PropositionSymbol>(SymbolCollector.getSymbolsFrom(s));
        return result;
    }

    protected Pair<PropositionSymbol, Boolean> findPureSymbol(List<PropositionSymbol> symbols, Set<Clause> clauses, Model model) {
        Pair result = null;
        HashSet<PropositionSymbol> symbolsToKeep = new HashSet<PropositionSymbol>(symbols);
        HashSet<PropositionSymbol> candidatePurePositiveSymbols = new HashSet<PropositionSymbol>();
        HashSet<PropositionSymbol> candidatePureNegativeSymbols = new HashSet<PropositionSymbol>();
        for (Clause c : clauses) {
            if (Boolean.TRUE.equals(model.determineValue(c))) continue;
            for (PropositionSymbol p : c.getPositiveSymbols()) {
                if (!symbolsToKeep.contains(p)) continue;
                candidatePurePositiveSymbols.add(p);
            }
            for (PropositionSymbol n : c.getNegativeSymbols()) {
                if (!symbolsToKeep.contains(n)) continue;
                candidatePureNegativeSymbols.add(n);
            }
        }
        for (PropositionSymbol s : symbolsToKeep) {
            if (!candidatePurePositiveSymbols.contains(s) || !candidatePureNegativeSymbols.contains(s)) continue;
            candidatePurePositiveSymbols.remove(s);
            candidatePureNegativeSymbols.remove(s);
        }
        if (candidatePurePositiveSymbols.size() > 0) {
            result = new Pair(candidatePurePositiveSymbols.iterator().next(), true);
        } else if (candidatePureNegativeSymbols.size() > 0) {
            result = new Pair(candidatePureNegativeSymbols.iterator().next(), false);
        }
        return result;
    }

    protected Pair<PropositionSymbol, Boolean> findUnitClause(Set<Clause> clauses, Model model) {
        Pair<PropositionSymbol, Boolean> result = null;
        for (Clause c : clauses) {
            if (model.determineValue(c) != null) continue;
            Literal unassigned = null;
            if (c.isUnitClause()) {
                unassigned = c.getLiterals().iterator().next();
            } else {
                for (Literal l : c.getLiterals()) {
                    Boolean value = model.getValue(l.getAtomicSentence());
                    if (value != null) continue;
                    if (unassigned == null) {
                        unassigned = l;
                        continue;
                    }
                    unassigned = null;
                    break;
                }
            }
            if (unassigned == null) continue;
            result = new Pair<PropositionSymbol, Boolean>(unassigned.getAtomicSentence(), unassigned.isPositiveLiteral());
            break;
        }
        return result;
    }

    protected boolean everyClauseTrue(Set<Clause> clauses, Model model) {
        return model.satisfies(clauses);
    }

    protected boolean someClauseFalse(Set<Clause> clauses, Model model) {
        for (Clause c : clauses) {
            if (!Boolean.FALSE.equals(model.determineValue(c))) continue;
            return true;
        }
        return false;
    }

    protected List<PropositionSymbol> minus(List<PropositionSymbol> symbols, PropositionSymbol p) {
        ArrayList<PropositionSymbol> result = new ArrayList<PropositionSymbol>(symbols.size());
        for (PropositionSymbol s : symbols) {
            if (p.equals(s)) continue;
            result.add(s);
        }
        return result;
    }
}

