/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.parsing.ast;

import aima.core.logic.fol.parsing.FOLVisitor;
import aima.core.logic.fol.parsing.ast.FOLNode;
import aima.core.logic.fol.parsing.ast.Sentence;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QuantifiedSentence
implements Sentence {
    private String quantifier;
    private List<Variable> variables = new ArrayList<Variable>();
    private Sentence quantified;
    private List<FOLNode> args = new ArrayList<FOLNode>();
    private String stringRep = null;
    private int hashCode = 0;

    public QuantifiedSentence(String quantifier, List<Variable> variables, Sentence quantified) {
        this.quantifier = quantifier;
        this.variables.addAll(variables);
        this.quantified = quantified;
        this.args.addAll(variables);
        this.args.add(quantified);
    }

    public String getQuantifier() {
        return this.quantifier;
    }

    public List<Variable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public Sentence getQuantified() {
        return this.quantified;
    }

    @Override
    public String getSymbolicName() {
        return this.getQuantifier();
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    public List<FOLNode> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    @Override
    public Object accept(FOLVisitor v, Object arg) {
        return v.visitQuantifiedSentence(this, arg);
    }

    @Override
    public QuantifiedSentence copy() {
        ArrayList<Variable> copyVars = new ArrayList<Variable>();
        for (Variable v : this.variables) {
            copyVars.add(v.copy());
        }
        return new QuantifiedSentence(this.quantifier, copyVars, this.quantified.copy());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuantifiedSentence cs = (QuantifiedSentence)o;
        return cs.quantifier.equals(this.quantifier) && cs.variables.equals(this.variables) && cs.quantified.equals(this.quantified);
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.quantifier.hashCode();
            for (Variable v : this.variables) {
                this.hashCode = 37 * this.hashCode + v.hashCode();
            }
            this.hashCode = this.hashCode * 37 + this.quantified.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.quantifier);
            sb.append(" ");
            for (Variable v : this.variables) {
                sb.append(v.toString());
                sb.append(" ");
            }
            sb.append(this.quantified.toString());
            this.stringRep = sb.toString();
        }
        return this.stringRep;
    }
}

