/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.parsing.ast;

import aima.core.logic.fol.parsing.FOLVisitor;
import aima.core.logic.fol.parsing.ast.AtomicSentence;
import aima.core.logic.fol.parsing.ast.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Predicate
implements AtomicSentence {
    private String predicateName;
    private List<Term> terms = new ArrayList<Term>();
    private String stringRep = null;
    private int hashCode = 0;

    public Predicate(String predicateName, List<Term> terms) {
        this.predicateName = predicateName;
        this.terms.addAll(terms);
    }

    public String getPredicateName() {
        return this.predicateName;
    }

    public List<Term> getTerms() {
        return Collections.unmodifiableList(this.terms);
    }

    @Override
    public String getSymbolicName() {
        return this.getPredicateName();
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public List<Term> getArgs() {
        return this.getTerms();
    }

    @Override
    public Object accept(FOLVisitor v, Object arg) {
        return v.visitPredicate(this, arg);
    }

    @Override
    public Predicate copy() {
        ArrayList<Term> copyTerms = new ArrayList<Term>();
        for (Term t : this.terms) {
            copyTerms.add(t.copy());
        }
        return new Predicate(this.predicateName, copyTerms);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Predicate)) {
            return false;
        }
        Predicate p = (Predicate)o;
        return p.getPredicateName().equals(this.getPredicateName()) && p.getTerms().equals(this.getTerms());
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.predicateName.hashCode();
            for (Term t : this.terms) {
                this.hashCode = 37 * this.hashCode + t.hashCode();
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.predicateName);
            sb.append("(");
            boolean first = true;
            for (Term t : this.terms) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(t.toString());
            }
            sb.append(")");
            this.stringRep = sb.toString();
        }
        return this.stringRep;
    }
}

