/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.parsing.ast;

import aima.core.logic.fol.parsing.FOLVisitor;
import aima.core.logic.fol.parsing.ast.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Function
implements Term {
    private String functionName;
    private List<Term> terms = new ArrayList<Term>();
    private String stringRep = null;
    private int hashCode = 0;

    public Function(String functionName, List<Term> terms) {
        this.functionName = functionName;
        this.terms.addAll(terms);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<Term> getTerms() {
        return Collections.unmodifiableList(this.terms);
    }

    @Override
    public String getSymbolicName() {
        return this.getFunctionName();
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public List<Term> getArgs() {
        return this.getTerms();
    }

    @Override
    public Object accept(FOLVisitor v, Object arg) {
        return v.visitFunction(this, arg);
    }

    @Override
    public Function copy() {
        ArrayList<Term> copyTerms = new ArrayList<Term>();
        for (Term t : this.terms) {
            copyTerms.add(t.copy());
        }
        return new Function(this.functionName, copyTerms);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Function)) {
            return false;
        }
        Function f = (Function)o;
        return f.getFunctionName().equals(this.getFunctionName()) && f.getTerms().equals(this.getTerms());
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.functionName.hashCode();
            for (Term t : this.terms) {
                this.hashCode = 37 * this.hashCode + t.hashCode();
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.functionName);
            sb.append("(");
            boolean first = true;
            for (Term t : this.terms) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(t.toString());
            }
            sb.append(")");
            this.stringRep = sb.toString();
        }
        return this.stringRep;
    }
}

