/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.parsing.ast;

import aima.core.logic.fol.parsing.FOLVisitor;
import aima.core.logic.fol.parsing.ast.Sentence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConnectedSentence
implements Sentence {
    private String connector;
    private Sentence first;
    private Sentence second;
    private List<Sentence> args = new ArrayList<Sentence>();
    private String stringRep = null;
    private int hashCode = 0;

    public ConnectedSentence(String connector, Sentence first, Sentence second) {
        this.connector = connector;
        this.first = first;
        this.second = second;
        this.args.add(first);
        this.args.add(second);
    }

    public String getConnector() {
        return this.connector;
    }

    public Sentence getFirst() {
        return this.first;
    }

    public Sentence getSecond() {
        return this.second;
    }

    @Override
    public String getSymbolicName() {
        return this.getConnector();
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    public List<Sentence> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    @Override
    public Object accept(FOLVisitor v, Object arg) {
        return v.visitConnectedSentence(this, arg);
    }

    @Override
    public ConnectedSentence copy() {
        return new ConnectedSentence(this.connector, this.first.copy(), this.second.copy());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedSentence cs = (ConnectedSentence)o;
        return cs.getConnector().equals(this.getConnector()) && cs.getFirst().equals(this.getFirst()) && cs.getSecond().equals(this.getSecond());
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getConnector().hashCode();
            this.hashCode = 37 * this.hashCode + this.getFirst().hashCode();
            this.hashCode = 37 * this.hashCode + this.getSecond().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this.first.toString());
            sb.append(" ");
            sb.append(this.connector);
            sb.append(" ");
            sb.append(this.second.toString());
            sb.append(")");
            this.stringRep = sb.toString();
        }
        return this.stringRep;
    }
}

