/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.parsing;

import aima.core.logic.common.Lexer;
import aima.core.logic.common.LexerException;
import aima.core.logic.common.Token;
import aima.core.logic.fol.domain.FOLDomain;
import java.util.HashSet;
import java.util.Set;

public class FOLLexer
extends Lexer {
    private FOLDomain domain;
    private Set<String> connectors;
    private Set<String> quantifiers;

    public FOLLexer(FOLDomain domain) {
        this.domain = domain;
        this.connectors = new HashSet<String>();
        this.connectors.add("NOT");
        this.connectors.add("AND");
        this.connectors.add("OR");
        this.connectors.add("=>");
        this.connectors.add("<=>");
        this.quantifiers = new HashSet<String>();
        this.quantifiers.add("FORALL");
        this.quantifiers.add("EXISTS");
    }

    public FOLDomain getFOLDomain() {
        return this.domain;
    }

    @Override
    public Token nextToken() {
        int startPosition = this.getCurrentPositionInInput();
        if (this.lookAhead(1) == '(') {
            this.consume();
            return new Token(2, "(", startPosition);
        }
        if (this.lookAhead(1) == ')') {
            this.consume();
            return new Token(3, ")", startPosition);
        }
        if (this.lookAhead(1) == ',') {
            this.consume();
            return new Token(6, ",", startPosition);
        }
        if (this.identifierDetected()) {
            return this.identifier();
        }
        if (Character.isWhitespace(this.lookAhead(1))) {
            this.consume();
            return this.nextToken();
        }
        if (this.lookAhead(1) == '\uffff') {
            return new Token(9999, "EOI", startPosition);
        }
        throw new LexerException("Lexing error on character " + this.lookAhead(1) + " at position " + this.getCurrentPositionInInput(), this.getCurrentPositionInInput());
    }

    private Token identifier() {
        int startPosition = this.getCurrentPositionInInput();
        StringBuffer sbuf = new StringBuffer();
        while (Character.isJavaIdentifierPart(this.lookAhead(1)) || this.partOfConnector()) {
            sbuf.append(this.lookAhead(1));
            this.consume();
        }
        String readString = new String(sbuf);
        if (this.connectors.contains(readString)) {
            return new Token(7, readString, startPosition);
        }
        if (this.quantifiers.contains(readString)) {
            return new Token(8, readString, startPosition);
        }
        if (this.domain.getPredicates().contains(readString)) {
            return new Token(9, readString, startPosition);
        }
        if (this.domain.getFunctions().contains(readString)) {
            return new Token(10, readString, startPosition);
        }
        if (this.domain.getConstants().contains(readString)) {
            return new Token(12, readString, startPosition);
        }
        if (this.isVariable(readString)) {
            return new Token(11, readString, startPosition);
        }
        if (readString.equals("=")) {
            return new Token(15, readString, startPosition);
        }
        throw new LexerException("Lexing error on character " + this.lookAhead(1) + " at position " + this.getCurrentPositionInInput(), this.getCurrentPositionInInput());
    }

    private boolean isVariable(String s) {
        return Character.isLowerCase(s.charAt(0));
    }

    private boolean identifierDetected() {
        return Character.isJavaIdentifierStart(this.lookAhead(1)) || this.partOfConnector();
    }

    private boolean partOfConnector() {
        return this.lookAhead(1) == '=' || this.lookAhead(1) == '<' || this.lookAhead(1) == '>';
    }
}

