/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.kb.data;

import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.parsing.ast.Constant;
import aima.core.logic.fol.parsing.ast.Function;
import aima.core.logic.fol.parsing.ast.Term;
import java.util.Comparator;
import java.util.List;

class LiteralsSorter
implements Comparator<Literal> {
    LiteralsSorter() {
    }

    @Override
    public int compare(Literal o1, Literal o2) {
        int rVal = 0;
        if (o1.isPositiveLiteral() != o2.isPositiveLiteral()) {
            if (o1.isPositiveLiteral()) {
                return 1;
            }
            return -1;
        }
        rVal = o1.getAtomicSentence().getSymbolicName().compareTo(o2.getAtomicSentence().getSymbolicName());
        if (0 == rVal) {
            rVal = this.compareArgs(o1.getAtomicSentence().getArgs(), o2.getAtomicSentence().getArgs());
        }
        return rVal;
    }

    private int compareArgs(List<Term> args1, List<Term> args2) {
        int rVal = 0;
        rVal = args1.size() - args2.size();
        if (0 == rVal && args1.size() > 0) {
            Term t1 = args1.get(0);
            Term t2 = args2.get(0);
            if (t1.getClass() == t2.getClass()) {
                if (t1 instanceof Constant) {
                    rVal = t1.getSymbolicName().compareTo(t2.getSymbolicName());
                } else if (t1 instanceof Function && 0 == (rVal = t1.getSymbolicName().compareTo(t2.getSymbolicName()))) {
                    rVal = this.compareArgs(t1.getArgs(), t2.getArgs());
                }
                if (0 == rVal) {
                    rVal = this.compareArgs(args1.subList(1, args1.size()), args2.subList(1, args2.size()));
                }
            } else {
                rVal = t1 instanceof Constant ? 1 : (t2 instanceof Constant ? -1 : (t1 instanceof Function ? 1 : -1));
            }
        }
        return rVal;
    }
}

