/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.kb.data;

import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.kb.data.LiteralsSorter;
import aima.core.logic.fol.parsing.FOLVisitor;
import aima.core.logic.fol.parsing.ast.ConnectedSentence;
import aima.core.logic.fol.parsing.ast.Constant;
import aima.core.logic.fol.parsing.ast.Function;
import aima.core.logic.fol.parsing.ast.NotSentence;
import aima.core.logic.fol.parsing.ast.Predicate;
import aima.core.logic.fol.parsing.ast.QuantifiedSentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.TermEquality;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ClauseEqualityIdentityConstructor
implements FOLVisitor {
    private StringBuilder identity = new StringBuilder();
    private int noVarPositions = 0;
    private int[] clauseVarCounts = null;
    private int currentLiteral = 0;
    private Map<String, List<Integer>> varPositions = new HashMap<String, List<Integer>>();

    public ClauseEqualityIdentityConstructor(List<Literal> literals, LiteralsSorter sorter) {
        this.clauseVarCounts = new int[literals.size()];
        for (Literal l : literals) {
            if (l.isNegativeLiteral()) {
                this.identity.append("~");
            }
            this.identity.append(l.getAtomicSentence().getSymbolicName());
            this.identity.append("(");
            boolean firstTerm = true;
            for (Term t : l.getAtomicSentence().getArgs()) {
                if (firstTerm) {
                    firstTerm = false;
                } else {
                    this.identity.append(",");
                }
                t.accept(this, null);
            }
            this.identity.append(")");
            ++this.currentLiteral;
        }
        int max = 0;
        int min = 0;
        for (int i = 0; i < literals.size(); ++i) {
            int incITo = i;
            int next = i + 1;
            max += this.clauseVarCounts[i];
            while (next < literals.size() && 0 == sorter.compare(literals.get(i), literals.get(next))) {
                max += this.clauseVarCounts[next];
                incITo = next++;
            }
            if (next - i > 1) {
                for (String key : this.varPositions.keySet()) {
                    List<Integer> positions = this.varPositions.get(key);
                    ArrayList<Integer> additPositions = new ArrayList<Integer>();
                    for (int pos : positions) {
                        if (pos < min || pos >= max) continue;
                        int pPos = pos;
                        int nPos = pos;
                        for (int candSlot = i; candSlot < next - 1; ++candSlot) {
                            if ((pPos += this.clauseVarCounts[i]) >= min && pPos < max && !positions.contains(pPos) && !additPositions.contains(pPos)) {
                                additPositions.add(pPos);
                            }
                            if ((nPos -= this.clauseVarCounts[i]) < min || nPos >= max || positions.contains(nPos) || additPositions.contains(nPos)) continue;
                            additPositions.add(nPos);
                        }
                    }
                    positions.addAll(additPositions);
                }
            }
            min = max;
            i = incITo;
        }
        int maxWidth = 1;
        while (this.noVarPositions >= 10) {
            this.noVarPositions /= 10;
            ++maxWidth;
        }
        ArrayList<String> varOffsets = new ArrayList<String>();
        for (String key : this.varPositions.keySet()) {
            List<Integer> positions = this.varPositions.get(key);
            Collections.sort(positions);
            StringBuilder sb = new StringBuilder();
            for (int pos : positions) {
                String posStr = Integer.toString(pos);
                int posStrLen = posStr.length();
                int padLen = maxWidth - posStrLen;
                for (int i = 0; i < padLen; ++i) {
                    sb.append('0');
                }
                sb.append(posStr);
            }
            varOffsets.add(sb.toString());
        }
        Collections.sort(varOffsets);
        for (int i = 0; i < varOffsets.size(); ++i) {
            this.identity.append((String)varOffsets.get(i));
            if (i >= varOffsets.size() - 1) continue;
            this.identity.append(",");
        }
    }

    public String getIdentity() {
        return this.identity.toString();
    }

    @Override
    public Object visitVariable(Variable var, Object arg) {
        this.identity.append("*");
        List<Integer> positions = this.varPositions.get(var.getValue());
        if (null == positions) {
            positions = new ArrayList<Integer>();
            this.varPositions.put(var.getValue(), positions);
        }
        positions.add(this.noVarPositions);
        ++this.noVarPositions;
        int n = this.currentLiteral;
        this.clauseVarCounts[n] = this.clauseVarCounts[n] + 1;
        return var;
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        this.identity.append(constant.getValue());
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object arg) {
        boolean firstTerm = true;
        this.identity.append(function.getFunctionName());
        this.identity.append("(");
        for (Term t : function.getTerms()) {
            if (firstTerm) {
                firstTerm = false;
            } else {
                this.identity.append(",");
            }
            t.accept(this, arg);
        }
        this.identity.append(")");
        return function;
    }

    @Override
    public Object visitPredicate(Predicate predicate, Object arg) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public Object visitTermEquality(TermEquality equality, Object arg) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public Object visitNotSentence(NotSentence sentence, Object arg) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
        throw new IllegalStateException("Should not be called");
    }
}

