/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.kb.data;

import aima.core.logic.fol.StandardizeApart;
import aima.core.logic.fol.StandardizeApartIndexical;
import aima.core.logic.fol.StandardizeApartIndexicalFactory;
import aima.core.logic.fol.SubstVisitor;
import aima.core.logic.fol.Unifier;
import aima.core.logic.fol.VariableCollector;
import aima.core.logic.fol.inference.proof.ProofStep;
import aima.core.logic.fol.inference.proof.ProofStepClauseBinaryResolvent;
import aima.core.logic.fol.inference.proof.ProofStepClauseFactor;
import aima.core.logic.fol.inference.proof.ProofStepPremise;
import aima.core.logic.fol.kb.data.ClauseEqualityIdentityConstructor;
import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.kb.data.LiteralsSorter;
import aima.core.logic.fol.parsing.ast.AtomicSentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.Variable;
import aima.core.util.math.MixedRadixNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Clause {
    private static StandardizeApartIndexical _saIndexical = StandardizeApartIndexicalFactory.newStandardizeApartIndexical(Character.valueOf('c'));
    private static Unifier _unifier = new Unifier();
    private static SubstVisitor _substVisitor = new SubstVisitor();
    private static VariableCollector _variableCollector = new VariableCollector();
    private static StandardizeApart _standardizeApart = new StandardizeApart();
    private static LiteralsSorter _literalSorter = new LiteralsSorter();
    private final Set<Literal> literals = new LinkedHashSet<Literal>();
    private final List<Literal> positiveLiterals = new ArrayList<Literal>();
    private final List<Literal> negativeLiterals = new ArrayList<Literal>();
    private boolean immutable = false;
    private boolean saCheckRequired = true;
    private String equalityIdentity = "";
    private Set<Clause> factors = null;
    private Set<Clause> nonTrivialFactors = null;
    private String stringRep = null;
    private ProofStep proofStep = null;

    public Clause() {
    }

    public Clause(List<Literal> lits) {
        this.literals.addAll(lits);
        for (Literal l : this.literals) {
            if (l.isPositiveLiteral()) {
                this.positiveLiterals.add(l);
                continue;
            }
            this.negativeLiterals.add(l);
        }
        this.recalculateIdentity();
    }

    public Clause(List<Literal> lits1, List<Literal> lits2) {
        this.literals.addAll(lits1);
        this.literals.addAll(lits2);
        for (Literal l : this.literals) {
            if (l.isPositiveLiteral()) {
                this.positiveLiterals.add(l);
                continue;
            }
            this.negativeLiterals.add(l);
        }
        this.recalculateIdentity();
    }

    public ProofStep getProofStep() {
        if (null == this.proofStep) {
            this.proofStep = new ProofStepPremise(this);
        }
        return this.proofStep;
    }

    public void setProofStep(ProofStep proofStep) {
        this.proofStep = proofStep;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable() {
        this.immutable = true;
    }

    public boolean isStandardizedApartCheckRequired() {
        return this.saCheckRequired;
    }

    public void setStandardizedApartCheckNotRequired() {
        this.saCheckRequired = false;
    }

    public boolean isEmpty() {
        return this.literals.size() == 0;
    }

    public boolean isUnitClause() {
        return this.literals.size() == 1;
    }

    public boolean isDefiniteClause() {
        return !this.isEmpty() && this.positiveLiterals.size() == 1;
    }

    public boolean isImplicationDefiniteClause() {
        return this.isDefiniteClause() && this.negativeLiterals.size() >= 1;
    }

    public boolean isHornClause() {
        return !this.isEmpty() && this.positiveLiterals.size() <= 1;
    }

    public boolean isTautology() {
        for (Literal pl : this.positiveLiterals) {
            for (Literal nl : this.negativeLiterals) {
                if (!pl.getAtomicSentence().equals(nl.getAtomicSentence())) continue;
                return true;
            }
        }
        return false;
    }

    public void addLiteral(Literal literal) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Clause is immutable, cannot be updated.");
        }
        int origSize = this.literals.size();
        this.literals.add(literal);
        if (this.literals.size() > origSize) {
            if (literal.isPositiveLiteral()) {
                this.positiveLiterals.add(literal);
            } else {
                this.negativeLiterals.add(literal);
            }
        }
        this.recalculateIdentity();
    }

    public void addPositiveLiteral(AtomicSentence atom) {
        this.addLiteral(new Literal(atom));
    }

    public void addNegativeLiteral(AtomicSentence atom) {
        this.addLiteral(new Literal(atom, true));
    }

    public int getNumberLiterals() {
        return this.literals.size();
    }

    public int getNumberPositiveLiterals() {
        return this.positiveLiterals.size();
    }

    public int getNumberNegativeLiterals() {
        return this.negativeLiterals.size();
    }

    public Set<Literal> getLiterals() {
        return Collections.unmodifiableSet(this.literals);
    }

    public List<Literal> getPositiveLiterals() {
        return Collections.unmodifiableList(this.positiveLiterals);
    }

    public List<Literal> getNegativeLiterals() {
        return Collections.unmodifiableList(this.negativeLiterals);
    }

    public Set<Clause> getFactors() {
        if (null == this.factors) {
            this.calculateFactors(null);
        }
        return Collections.unmodifiableSet(this.factors);
    }

    public Set<Clause> getNonTrivialFactors() {
        if (null == this.nonTrivialFactors) {
            this.calculateFactors(null);
        }
        return Collections.unmodifiableSet(this.nonTrivialFactors);
    }

    public boolean subsumes(Clause othC) {
        boolean subsumes = false;
        if (this != othC && this.getNumberLiterals() < othC.getNumberLiterals() && this.getNumberPositiveLiterals() <= othC.getNumberPositiveLiterals() && this.getNumberNegativeLiterals() <= othC.getNumberNegativeLiterals()) {
            Map<String, List<Literal>> thisToTry = this.collectLikeLiterals(this.literals);
            Map<String, List<Literal>> othCToTry = this.collectLikeLiterals(othC.literals);
            if (othCToTry.keySet().containsAll(thisToTry.keySet())) {
                boolean isAPossSubset = true;
                for (String pk : thisToTry.keySet()) {
                    if (thisToTry.get(pk).size() <= othCToTry.get(pk).size()) continue;
                    isAPossSubset = false;
                    break;
                }
                if (isAPossSubset) {
                    subsumes = this.checkSubsumes(othC, thisToTry, othCToTry);
                }
            }
        }
        return subsumes;
    }

    public Set<Clause> binaryResolvents(Clause othC) {
        LinkedHashSet<Clause> resolvents = new LinkedHashSet<Clause>();
        if (this.isEmpty() && othC.isEmpty()) {
            resolvents.add(new Clause());
            return resolvents;
        }
        othC = this.saIfRequired(othC);
        ArrayList<Literal> allPosLits = new ArrayList<Literal>();
        ArrayList<Literal> allNegLits = new ArrayList<Literal>();
        allPosLits.addAll(this.positiveLiterals);
        allPosLits.addAll(othC.positiveLiterals);
        allNegLits.addAll(this.negativeLiterals);
        allNegLits.addAll(othC.negativeLiterals);
        ArrayList<Literal> trPosLits = new ArrayList<Literal>();
        ArrayList<Literal> trNegLits = new ArrayList<Literal>();
        ArrayList<Literal> copyRPosLits = new ArrayList<Literal>();
        ArrayList<Literal> copyRNegLits = new ArrayList<Literal>();
        for (int i = 0; i < 2; ++i) {
            trPosLits.clear();
            trNegLits.clear();
            if (i == 0) {
                trPosLits.addAll(this.positiveLiterals);
                trNegLits.addAll(othC.negativeLiterals);
            } else {
                trPosLits.addAll(othC.positiveLiterals);
                trNegLits.addAll(this.negativeLiterals);
            }
            LinkedHashMap<Variable, Term> copyRBindings = new LinkedHashMap<Variable, Term>();
            for (Literal pl : trPosLits) {
                for (Literal nl : trNegLits) {
                    copyRBindings.clear();
                    if (null == _unifier.unify(pl.getAtomicSentence(), nl.getAtomicSentence(), copyRBindings)) continue;
                    copyRPosLits.clear();
                    copyRNegLits.clear();
                    boolean found = false;
                    for (Literal l : allPosLits) {
                        if (!found && pl.equals(l)) {
                            found = true;
                            continue;
                        }
                        copyRPosLits.add(_substVisitor.subst(copyRBindings, l));
                    }
                    found = false;
                    for (Literal l : allNegLits) {
                        if (!found && nl.equals(l)) {
                            found = true;
                            continue;
                        }
                        copyRNegLits.add(_substVisitor.subst(copyRBindings, l));
                    }
                    Map<Variable, Term> renameSubstitituon = _standardizeApart.standardizeApart(copyRPosLits, copyRNegLits, _saIndexical);
                    Clause c = new Clause(copyRPosLits, copyRNegLits);
                    c.setProofStep(new ProofStepClauseBinaryResolvent(c, pl, nl, this, othC, copyRBindings, renameSubstitituon));
                    if (this.isImmutable()) {
                        c.setImmutable();
                    }
                    if (!this.isStandardizedApartCheckRequired()) {
                        c.setStandardizedApartCheckNotRequired();
                    }
                    resolvents.add(c);
                }
            }
        }
        return resolvents;
    }

    public String toString() {
        if (null == this.stringRep) {
            ArrayList<Literal> sortedLiterals = new ArrayList<Literal>(this.literals);
            Collections.sort(sortedLiterals, _literalSorter);
            this.stringRep = ((Object)sortedLiterals).toString();
        }
        return this.stringRep;
    }

    public int hashCode() {
        return this.equalityIdentity.hashCode();
    }

    public boolean equals(Object othObj) {
        if (null == othObj) {
            return false;
        }
        if (this == othObj) {
            return true;
        }
        if (!(othObj instanceof Clause)) {
            return false;
        }
        Clause othClause = (Clause)othObj;
        return this.equalityIdentity.equals(othClause.equalityIdentity);
    }

    public String getEqualityIdentity() {
        return this.equalityIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateIdentity() {
        Clause clause = this;
        synchronized (clause) {
            ArrayList<Literal> sortedLiterals = new ArrayList<Literal>(this.literals);
            Collections.sort(sortedLiterals, _literalSorter);
            ClauseEqualityIdentityConstructor ceic = new ClauseEqualityIdentityConstructor(sortedLiterals, _literalSorter);
            this.equalityIdentity = ceic.getIdentity();
            this.factors = null;
            this.nonTrivialFactors = null;
            this.stringRep = null;
        }
    }

    private void calculateFactors(Set<Clause> parentFactors) {
        this.nonTrivialFactors = new LinkedHashSet<Clause>();
        HashMap<Variable, Term> theta = new HashMap<Variable, Term>();
        ArrayList<Literal> lits = new ArrayList<Literal>();
        for (int i = 0; i < 2; ++i) {
            lits.clear();
            if (i == 0) {
                lits.addAll(this.positiveLiterals);
            } else {
                lits.addAll(this.negativeLiterals);
            }
            for (int x = 0; x < lits.size(); ++x) {
                for (int y = x + 1; y < lits.size(); ++y) {
                    Literal litX = (Literal)lits.get(x);
                    Literal litY = (Literal)lits.get(y);
                    theta.clear();
                    Map<Variable, Term> substitution = _unifier.unify(litX.getAtomicSentence(), litY.getAtomicSentence(), theta);
                    if (null == substitution) continue;
                    ArrayList<Literal> posLits = new ArrayList<Literal>();
                    ArrayList<Literal> negLits = new ArrayList<Literal>();
                    if (i == 0) {
                        posLits.add(_substVisitor.subst(substitution, litX));
                    } else {
                        negLits.add(_substVisitor.subst(substitution, litX));
                    }
                    for (Literal pl : this.positiveLiterals) {
                        if (pl == litX || pl == litY) continue;
                        posLits.add(_substVisitor.subst(substitution, pl));
                    }
                    for (Literal nl : this.negativeLiterals) {
                        if (nl == litX || nl == litY) continue;
                        negLits.add(_substVisitor.subst(substitution, nl));
                    }
                    Map<Variable, Term> renameSubst = _standardizeApart.standardizeApart(posLits, negLits, _saIndexical);
                    Clause c = new Clause(posLits, negLits);
                    c.setProofStep(new ProofStepClauseFactor(c, this, litX, litY, substitution, renameSubst));
                    if (this.isImmutable()) {
                        c.setImmutable();
                    }
                    if (!this.isStandardizedApartCheckRequired()) {
                        c.setStandardizedApartCheckNotRequired();
                    }
                    if (null == parentFactors) {
                        c.calculateFactors(this.nonTrivialFactors);
                        this.nonTrivialFactors.addAll(c.getFactors());
                        continue;
                    }
                    if (parentFactors.contains(c)) continue;
                    c.calculateFactors(this.nonTrivialFactors);
                    this.nonTrivialFactors.addAll(c.getFactors());
                }
            }
        }
        this.factors = new LinkedHashSet<Clause>();
        this.factors.add(this);
        this.factors.addAll(this.nonTrivialFactors);
    }

    private Clause saIfRequired(Clause othClause) {
        if (this.isStandardizedApartCheckRequired() || this == othClause) {
            Set<Variable> mVariables = _variableCollector.collectAllVariables(this);
            Set<Variable> oVariables = _variableCollector.collectAllVariables(othClause);
            HashSet<Variable> cVariables = new HashSet<Variable>();
            cVariables.addAll(mVariables);
            cVariables.addAll(oVariables);
            if (cVariables.size() < mVariables.size() + oVariables.size()) {
                othClause = _standardizeApart.standardizeApart(othClause, _saIndexical);
            }
        }
        return othClause;
    }

    private Map<String, List<Literal>> collectLikeLiterals(Set<Literal> literals) {
        HashMap<String, List<Literal>> likeLiterals = new HashMap<String, List<Literal>>();
        for (Literal l : literals) {
            String literalName = (l.isNegativeLiteral() ? "~" : "") + l.getAtomicSentence().getSymbolicName() + "/" + l.getAtomicSentence().getArgs().size();
            ArrayList<Literal> like = (ArrayList<Literal>)likeLiterals.get(literalName);
            if (null == like) {
                like = new ArrayList<Literal>();
                likeLiterals.put(literalName, like);
            }
            like.add(l);
        }
        return likeLiterals;
    }

    private boolean checkSubsumes(Clause othC, Map<String, List<Literal>> thisToTry, Map<String, List<Literal>> othCToTry) {
        boolean subsumes = false;
        ArrayList<Term> thisTerms = new ArrayList<Term>();
        ArrayList<Term> othCTerms = new ArrayList<Term>();
        ArrayList<Integer> radices = new ArrayList<Integer>();
        for (String literalName : thisToTry.keySet()) {
            int sizeT = thisToTry.get(literalName).size();
            int sizeO = othCToTry.get(literalName).size();
            if (sizeO > 1) {
                for (int i = 0; i < sizeT; ++i) {
                    int r = sizeO - i;
                    if (r <= 1) continue;
                    radices.add(r);
                }
            }
            for (Literal tl : thisToTry.get(literalName)) {
                thisTerms.addAll(tl.getAtomicSentence().getArgs());
            }
        }
        MixedRadixNumber permutation = null;
        long numPermutations = 1L;
        if (radices.size() > 0) {
            permutation = new MixedRadixNumber(0L, radices);
            numPermutations = permutation.getMaxAllowedValue() + 1L;
        }
        Set<Variable> othCVariables = _variableCollector.collectAllVariables(othC);
        LinkedHashMap<Variable, Term> theta = new LinkedHashMap<Variable, Term>();
        ArrayList literalPermuations = new ArrayList();
        for (long l = 0L; l < numPermutations; ++l) {
            othCTerms.clear();
            int radixIdx = 0;
            for (String literalName : thisToTry.keySet()) {
                int sizeT = thisToTry.get(literalName).size();
                literalPermuations.clear();
                literalPermuations.addAll(othCToTry.get(literalName));
                int sizeO = literalPermuations.size();
                if (sizeO > 1) {
                    for (int i = 0; i < sizeT; ++i) {
                        int r = sizeO - i;
                        if (r > 1) {
                            int numPos = permutation.getCurrentNumeralValue(radixIdx);
                            othCTerms.addAll(((Literal)literalPermuations.remove(numPos)).getAtomicSentence().getArgs());
                            ++radixIdx;
                            continue;
                        }
                        othCTerms.addAll(((Literal)literalPermuations.get(0)).getAtomicSentence().getArgs());
                    }
                    continue;
                }
                othCTerms.addAll(((Literal)literalPermuations.get(0)).getAtomicSentence().getArgs());
            }
            theta.clear();
            if (null != _unifier.unify(thisTerms, othCTerms, theta)) {
                boolean containsAny = false;
                for (Variable v : theta.keySet()) {
                    if (!othCVariables.contains(v)) continue;
                    containsAny = true;
                    break;
                }
                if (!containsAny) {
                    subsumes = true;
                    break;
                }
            }
            if (null == permutation) continue;
            permutation.increment();
        }
        return subsumes;
    }
}

