/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.kb.data;

import aima.core.logic.fol.inference.proof.ProofStep;
import aima.core.logic.fol.inference.proof.ProofStepChainContrapositive;
import aima.core.logic.fol.inference.proof.ProofStepPremise;
import aima.core.logic.fol.kb.data.Literal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Chain {
    private static List<Literal> _emptyLiteralsList = Collections.unmodifiableList(new ArrayList());
    private List<Literal> literals = new ArrayList<Literal>();
    private ProofStep proofStep = null;

    public Chain() {
    }

    public Chain(List<Literal> literals) {
        this.literals.addAll(literals);
    }

    public Chain(Set<Literal> literals) {
        this.literals.addAll(literals);
    }

    public ProofStep getProofStep() {
        if (null == this.proofStep) {
            this.proofStep = new ProofStepPremise(this);
        }
        return this.proofStep;
    }

    public void setProofStep(ProofStep proofStep) {
        this.proofStep = proofStep;
    }

    public boolean isEmpty() {
        return this.literals.size() == 0;
    }

    public void addLiteral(Literal literal) {
        this.literals.add(literal);
    }

    public Literal getHead() {
        if (0 == this.literals.size()) {
            return null;
        }
        return this.literals.get(0);
    }

    public List<Literal> getTail() {
        if (0 == this.literals.size()) {
            return _emptyLiteralsList;
        }
        return Collections.unmodifiableList(this.literals.subList(1, this.literals.size()));
    }

    public int getNumberLiterals() {
        return this.literals.size();
    }

    public List<Literal> getLiterals() {
        return Collections.unmodifiableList(this.literals);
    }

    public List<Chain> getContrapositives() {
        ArrayList<Chain> contrapositives = new ArrayList<Chain>();
        ArrayList<Literal> lits = new ArrayList<Literal>();
        for (int i = 1; i < this.literals.size(); ++i) {
            lits.clear();
            lits.add(this.literals.get(i));
            lits.addAll(this.literals.subList(0, i));
            lits.addAll(this.literals.subList(i + 1, this.literals.size()));
            Chain cont = new Chain(lits);
            cont.setProofStep(new ProofStepChainContrapositive(cont, this));
            contrapositives.add(cont);
        }
        return contrapositives;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        for (int i = 0; i < this.literals.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.literals.get(i).toString());
        }
        sb.append(">");
        return sb.toString();
    }
}

