/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.kb;

import aima.core.logic.fol.CNFConverter;
import aima.core.logic.fol.StandardizeApart;
import aima.core.logic.fol.StandardizeApartIndexical;
import aima.core.logic.fol.StandardizeApartIndexicalFactory;
import aima.core.logic.fol.StandardizeApartResult;
import aima.core.logic.fol.SubstVisitor;
import aima.core.logic.fol.Unifier;
import aima.core.logic.fol.VariableCollector;
import aima.core.logic.fol.domain.FOLDomain;
import aima.core.logic.fol.inference.FOLOTTERLikeTheoremProver;
import aima.core.logic.fol.inference.InferenceProcedure;
import aima.core.logic.fol.inference.InferenceResult;
import aima.core.logic.fol.inference.proof.Proof;
import aima.core.logic.fol.inference.proof.ProofStepClauseClausifySentence;
import aima.core.logic.fol.kb.data.CNF;
import aima.core.logic.fol.kb.data.Chain;
import aima.core.logic.fol.kb.data.Clause;
import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.parsing.FOLParser;
import aima.core.logic.fol.parsing.ast.FOLNode;
import aima.core.logic.fol.parsing.ast.Predicate;
import aima.core.logic.fol.parsing.ast.Sentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FOLKnowledgeBase {
    private FOLParser parser;
    private InferenceProcedure inferenceProcedure;
    private Unifier unifier;
    private SubstVisitor substVisitor;
    private VariableCollector variableCollector;
    private StandardizeApart standardizeApart;
    private CNFConverter cnfConverter;
    private List<Sentence> originalSentences = new ArrayList<Sentence>();
    private Set<Clause> clauses = new LinkedHashSet<Clause>();
    private List<Clause> allDefiniteClauses = new ArrayList<Clause>();
    private List<Clause> implicationDefiniteClauses = new ArrayList<Clause>();
    private Map<String, List<Literal>> indexFacts = new HashMap<String, List<Literal>>();
    private StandardizeApartIndexical variableIndexical = StandardizeApartIndexicalFactory.newStandardizeApartIndexical(Character.valueOf('v'));
    private StandardizeApartIndexical queryIndexical = StandardizeApartIndexicalFactory.newStandardizeApartIndexical(Character.valueOf('q'));

    public FOLKnowledgeBase(FOLDomain domain) {
        this(domain, new FOLOTTERLikeTheoremProver());
    }

    public FOLKnowledgeBase(FOLDomain domain, InferenceProcedure inferenceProcedure) {
        this(domain, inferenceProcedure, new Unifier());
    }

    public FOLKnowledgeBase(FOLDomain domain, InferenceProcedure inferenceProcedure, Unifier unifier) {
        this.parser = new FOLParser(new FOLDomain(domain));
        this.inferenceProcedure = inferenceProcedure;
        this.unifier = unifier;
        this.substVisitor = new SubstVisitor();
        this.variableCollector = new VariableCollector();
        this.standardizeApart = new StandardizeApart(this.variableCollector, this.substVisitor);
        this.cnfConverter = new CNFConverter(this.parser);
    }

    public void clear() {
        this.originalSentences.clear();
        this.clauses.clear();
        this.allDefiniteClauses.clear();
        this.implicationDefiniteClauses.clear();
        this.indexFacts.clear();
    }

    public InferenceProcedure getInferenceProcedure() {
        return this.inferenceProcedure;
    }

    public void setInferenceProcedure(InferenceProcedure inferenceProcedure) {
        if (null != inferenceProcedure) {
            this.inferenceProcedure = inferenceProcedure;
        }
    }

    public Sentence tell(String sentence) {
        Sentence s = this.parser.parse(sentence);
        this.tell(s);
        return s;
    }

    public void tell(List<? extends Sentence> sentences) {
        for (Sentence sentence : sentences) {
            this.tell(sentence);
        }
    }

    public void tell(Sentence sentence) {
        this.store(sentence);
    }

    public InferenceResult ask(String querySentence) {
        return this.ask(this.parser.parse(querySentence));
    }

    public InferenceResult ask(Sentence query) {
        StandardizeApartResult saResult = this.standardizeApart.standardizeApart(query, this.queryIndexical);
        InferenceResult infResult = this.getInferenceProcedure().ask(this, saResult.getStandardized());
        for (Proof p : infResult.getProofs()) {
            Map<Variable, Term> im = p.getAnswerBindings();
            LinkedHashMap<Variable, Term> em = new LinkedHashMap<Variable, Term>();
            for (Variable rev : saResult.getReverseSubstitution().keySet()) {
                em.put((Variable)saResult.getReverseSubstitution().get(rev), im.get(rev));
            }
            p.replaceAnswerBindings(em);
        }
        return infResult;
    }

    public int getNumberFacts() {
        return this.allDefiniteClauses.size() - this.implicationDefiniteClauses.size();
    }

    public int getNumberRules() {
        return this.clauses.size() - this.getNumberFacts();
    }

    public List<Sentence> getOriginalSentences() {
        return Collections.unmodifiableList(this.originalSentences);
    }

    public List<Clause> getAllDefiniteClauses() {
        return Collections.unmodifiableList(this.allDefiniteClauses);
    }

    public List<Clause> getAllDefiniteClauseImplications() {
        return Collections.unmodifiableList(this.implicationDefiniteClauses);
    }

    public Set<Clause> getAllClauses() {
        return Collections.unmodifiableSet(this.clauses);
    }

    public synchronized Set<Map<Variable, Term>> fetch(Literal l) {
        LinkedHashSet<Map<Variable, Term>> allUnifiers = new LinkedHashSet<Map<Variable, Term>>();
        List<Literal> matchingFacts = this.fetchMatchingFacts(l);
        if (null != matchingFacts) {
            for (Literal fact : matchingFacts) {
                Map<Variable, Term> substitution = this.unifier.unify(l.getAtomicSentence(), fact.getAtomicSentence());
                if (null == substitution) continue;
                allUnifiers.add(substitution);
            }
        }
        return allUnifiers;
    }

    public Set<Map<Variable, Term>> fetch(List<Literal> literals) {
        LinkedHashSet<Map<Variable, Term>> possibleSubstitutions = new LinkedHashSet<Map<Variable, Term>>();
        if (literals.size() > 0) {
            Literal first = literals.get(0);
            List<Literal> rest = literals.subList(1, literals.size());
            this.recursiveFetch(new LinkedHashMap<Variable, Term>(), first, rest, possibleSubstitutions);
        }
        return possibleSubstitutions;
    }

    public Map<Variable, Term> unify(FOLNode x, FOLNode y) {
        return this.unifier.unify(x, y);
    }

    public Sentence subst(Map<Variable, Term> theta, Sentence aSentence) {
        return this.substVisitor.subst(theta, aSentence);
    }

    public Literal subst(Map<Variable, Term> theta, Literal l) {
        return this.substVisitor.subst(theta, l);
    }

    public Term subst(Map<Variable, Term> theta, Term term) {
        return this.substVisitor.subst(theta, term);
    }

    public Sentence standardizeApart(Sentence sentence) {
        return this.standardizeApart.standardizeApart(sentence, this.variableIndexical).getStandardized();
    }

    public Clause standardizeApart(Clause clause) {
        return this.standardizeApart.standardizeApart(clause, this.variableIndexical);
    }

    public Chain standardizeApart(Chain chain) {
        return this.standardizeApart.standardizeApart(chain, this.variableIndexical);
    }

    public Set<Variable> collectAllVariables(Sentence sentence) {
        return this.variableCollector.collectAllVariables(sentence);
    }

    public CNF convertToCNF(Sentence sentence) {
        return this.cnfConverter.convertToCNF(sentence);
    }

    public Set<Clause> convertToClauses(Sentence sentence) {
        CNF cnf = this.cnfConverter.convertToCNF(sentence);
        return new LinkedHashSet<Clause>(cnf.getConjunctionOfClauses());
    }

    public Literal createAnswerLiteral(Sentence forQuery) {
        String alName = this.parser.getFOLDomain().addAnswerLiteral();
        ArrayList<Term> terms = new ArrayList<Term>();
        Set<Variable> vars = this.variableCollector.collectAllVariables(forQuery);
        for (Variable v : vars) {
            terms.add(v.copy());
        }
        return new Literal(new Predicate(alName, terms));
    }

    public boolean isRenaming(Literal l) {
        List<Literal> possibleMatches = this.fetchMatchingFacts(l);
        if (null != possibleMatches) {
            return this.isRenaming(l, possibleMatches);
        }
        return false;
    }

    public boolean isRenaming(Literal l, List<Literal> possibleMatches) {
        for (Literal q : possibleMatches) {
            Map<Variable, Term> subst;
            if (l.isPositiveLiteral() != q.isPositiveLiteral() || null == (subst = this.unifier.unify(l.getAtomicSentence(), q.getAtomicSentence()))) continue;
            int cntVarTerms = 0;
            for (Term t : subst.values()) {
                if (!(t instanceof Variable)) continue;
                ++cntVarTerms;
            }
            if (subst.size() != cntVarTerms) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Sentence s : this.originalSentences) {
            sb.append(s.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    protected FOLParser getParser() {
        return this.parser;
    }

    private synchronized void store(Sentence sentence) {
        this.originalSentences.add(sentence);
        CNF cnfOfOrig = this.cnfConverter.convertToCNF(sentence);
        for (Clause c : cnfOfOrig.getConjunctionOfClauses()) {
            c.setProofStep(new ProofStepClauseClausifySentence(c, sentence));
            if (c.isEmpty()) {
                throw new IllegalArgumentException("Attempted to add unsatisfiable sentence to KB, orig=[" + sentence + "] CNF=" + cnfOfOrig);
            }
            c = this.standardizeApart.standardizeApart(c, this.variableIndexical);
            c.setImmutable();
            if (!this.clauses.add(c)) continue;
            if (c.isDefiniteClause()) {
                this.allDefiniteClauses.add(c);
            }
            if (c.isImplicationDefiniteClause()) {
                this.implicationDefiniteClauses.add(c);
            }
            if (!c.isUnitClause()) continue;
            this.indexFact(c.getLiterals().iterator().next());
        }
    }

    private void indexFact(Literal fact) {
        String factKey = this.getFactKey(fact);
        if (!this.indexFacts.containsKey(factKey)) {
            this.indexFacts.put(factKey, new ArrayList());
        }
        this.indexFacts.get(factKey).add(fact);
    }

    private void recursiveFetch(Map<Variable, Term> theta, Literal l, List<Literal> remainingLiterals, Set<Map<Variable, Term>> possibleSubstitutions) {
        Set<Map<Variable, Term>> pSubsts = this.fetch(this.subst(theta, l));
        if (null == pSubsts) {
            return;
        }
        for (Map<Variable, Term> psubst : pSubsts) {
            psubst.putAll(theta);
            if (remainingLiterals.size() == 0) {
                possibleSubstitutions.add(psubst);
                continue;
            }
            Literal first = remainingLiterals.get(0);
            List<Literal> rest = remainingLiterals.subList(1, remainingLiterals.size());
            this.recursiveFetch(psubst, first, rest, possibleSubstitutions);
        }
    }

    private List<Literal> fetchMatchingFacts(Literal l) {
        return this.indexFacts.get(this.getFactKey(l));
    }

    private String getFactKey(Literal l) {
        StringBuilder key = new StringBuilder();
        if (l.isPositiveLiteral()) {
            key.append("+");
        } else {
            key.append("-");
        }
        key.append(l.getAtomicSentence().getSymbolicName());
        return key.toString();
    }
}

