/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.inference.proof;

import aima.core.logic.fol.inference.proof.AbstractProofStep;
import aima.core.logic.fol.inference.proof.ProofStep;
import aima.core.logic.fol.kb.data.Clause;
import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ProofStepFoChAssertFact
extends AbstractProofStep {
    private List<ProofStep> predecessors = new ArrayList<ProofStep>();
    private Clause implication = null;
    private Literal fact = null;
    private Map<Variable, Term> bindings = null;

    public ProofStepFoChAssertFact(Clause implication, Literal fact, Map<Variable, Term> bindings, ProofStep predecessor) {
        this.implication = implication;
        this.fact = fact;
        this.bindings = bindings;
        if (null != predecessor) {
            this.predecessors.add(predecessor);
        }
    }

    @Override
    public List<ProofStep> getPredecessorSteps() {
        return Collections.unmodifiableList(this.predecessors);
    }

    @Override
    public String getProof() {
        StringBuilder sb = new StringBuilder();
        List<Literal> nLits = this.implication.getNegativeLiterals();
        for (int i = 0; i < this.implication.getNumberNegativeLiterals(); ++i) {
            sb.append(nLits.get(i).getAtomicSentence());
            if (i == this.implication.getNumberNegativeLiterals() - 1) continue;
            sb.append(" AND ");
        }
        sb.append(" => ");
        sb.append(this.implication.getPositiveLiterals().get(0));
        return sb.toString();
    }

    @Override
    public String getJustification() {
        return "Assert fact " + this.fact.toString() + ", " + this.bindings;
    }
}

