/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.inference.proof;

import aima.core.logic.fol.inference.proof.Proof;
import aima.core.logic.fol.inference.proof.ProofStep;
import aima.core.logic.fol.inference.proof.ProofStepGoal;
import aima.core.logic.fol.inference.proof.ProofStepPremise;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProofFinal
implements Proof {
    private Map<Variable, Term> answerBindings = new LinkedHashMap<Variable, Term>();
    private ProofStep finalStep = null;
    private List<ProofStep> proofSteps = null;

    public ProofFinal(ProofStep finalStep, Map<Variable, Term> answerBindings) {
        this.finalStep = finalStep;
        this.answerBindings.putAll(answerBindings);
    }

    @Override
    public List<ProofStep> getSteps() {
        if (null == this.proofSteps) {
            this.calcualteProofSteps();
        }
        return this.proofSteps;
    }

    @Override
    public Map<Variable, Term> getAnswerBindings() {
        return this.answerBindings;
    }

    @Override
    public void replaceAnswerBindings(Map<Variable, Term> updatedBindings) {
        this.answerBindings.clear();
        this.answerBindings.putAll(updatedBindings);
    }

    public String toString() {
        return this.answerBindings.toString();
    }

    private void calcualteProofSteps() {
        ProofStep m;
        int i;
        this.proofSteps = new ArrayList<ProofStep>();
        this.addToProofSteps(this.finalStep);
        int to = 0;
        for (i = 0; i < this.proofSteps.size(); ++i) {
            if (!(this.proofSteps.get(i) instanceof ProofStepPremise)) continue;
            m = this.proofSteps.remove(i);
            this.proofSteps.add(to, m);
            ++to;
        }
        for (i = 0; i < this.proofSteps.size(); ++i) {
            if (!(this.proofSteps.get(i) instanceof ProofStepGoal)) continue;
            m = this.proofSteps.remove(i);
            this.proofSteps.add(to, m);
            ++to;
        }
        for (i = 0; i < this.proofSteps.size(); ++i) {
            this.proofSteps.get(i).setStepNumber(i + 1);
        }
    }

    private void addToProofSteps(ProofStep step) {
        if (!this.proofSteps.contains(step)) {
            this.proofSteps.add(0, step);
        } else {
            this.proofSteps.remove(step);
            this.proofSteps.add(0, step);
        }
        List<ProofStep> predecessors = step.getPredecessorSteps();
        for (int i = predecessors.size() - 1; i >= 0; --i) {
            this.addToProofSteps(predecessors.get(i));
        }
    }
}

